/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import model.board.BoardInitializeData;
import model.board.Dimension;
import model.board.Game;
import model.board.Position;
import model.figure.EmptyFigure;
import model.player.Bot;
import model.player.NetWork;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import server.AfterDisconnect;
import server.BombsToUpdate;
import server.ClientBomb;
import server.GameEvent;
import server.GameFinish;
import server.Init;
import server.NetworkConnector;
import server.PlayerDisconnect;
import server.PlayerJoining;
import server.StartingMenuUpdate;
import service.BoardService;
import service.DelayerService;
import service.GameFactory;
import service.GameProgressService;
import service.GameService;
import view.BoardGraphicalUi;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001f\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lserver/Server;", "", "updateNetWorkNumber", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "boardGraphicalUi", "Lview/BoardGraphicalUi;", "game", "Lmodel/board/Game;", "hasGameStarted", "", "netWorkConnector", "Lserver/NetworkConnector;", "createGame", "frame", "Ljavax/swing/JFrame;", "boardData", "Lmodel/board/BoardInitializeData;", "getCurrentPlayer", "Lmodel/player/Player;", "getNetworkPlayerNames", "", "", "handlePacket", "gameEvent", "Lserver/GameEvent;", "resetPlayers", "sendEventToAllNetworkClients", "sendGameUpdateToAll", "setServerToConnector", "start", "stopGameRunningFlag", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\nserver/Server\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1855#3,2:145\n*S KotlinDebug\n*F\n+ 1 Server.kt\nserver/Server\n*L\n74#1:145,2\n*E\n"})
public final class Server {
    @NotNull
    private final Function1<Integer, Unit> updateNetWorkNumber;
    @NotNull
    private final NetworkConnector netWorkConnector;
    @NotNull
    private final BoardGraphicalUi boardGraphicalUi;
    @NotNull
    private Game game;
    private boolean hasGameStarted;

    public Server(@NotNull Function1<? super Integer, Unit> updateNetWorkNumber) {
        Intrinsics.checkNotNullParameter(updateNetWorkNumber, "updateNetWorkNumber");
        this.updateNetWorkNumber = updateNetWorkNumber;
        this.netWorkConnector = new NetworkConnector();
        this.boardGraphicalUi = new BoardGraphicalUi(true);
        this.game = GameFactory.INSTANCE.create(new BoardInitializeData(new Dimension(1, 1), 0, new ArrayList()));
    }

    public final void start() {
        this.netWorkConnector.bind((Function1<? super GameEvent, Unit>)new Function1<GameEvent, Unit>((Object)this){

            public final void invoke(@NotNull GameEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Server)this.receiver).handlePacket(p0);
            }
        }, (Function0<? extends Player>)new Function0<Player>((Object)this){

            @Nullable
            public final Player invoke() {
                return Server.access$getCurrentPlayer((Server)this.receiver);
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Server.access$getHasGameStarted$p(this.this$0);
            }
        });
        this.netWorkConnector.start();
    }

    public final void handlePacket(@NotNull GameEvent gameEvent) {
        block16: {
            GameEvent gameEvent2;
            block18: {
                block20: {
                    block19: {
                        block17: {
                            block15: {
                                Intrinsics.checkNotNullParameter(gameEvent, "gameEvent");
                                gameEvent2 = gameEvent;
                                if (!(gameEvent2 instanceof BombsToUpdate)) break block15;
                                this.sendGameUpdateToAll(gameEvent);
                                break block16;
                            }
                            if (!(gameEvent2 instanceof PlayerJoining)) break block17;
                            this.updateNetWorkNumber.invoke(((PlayerJoining)gameEvent).getNumberOfPlayers());
                            this.sendGameUpdateToAll(gameEvent);
                            break block16;
                        }
                        if (!(gameEvent2 instanceof ClientBomb)) break block18;
                        if (!(this.game.getCurrent() instanceof NetWork)) break block19;
                        Player player = this.game.getCurrent();
                        if (Intrinsics.areEqual(player != null ? player.getName() : null, ((ClientBomb)gameEvent).getPlayerPlacedName())) break block20;
                    }
                    if (this.game.getCurrent() instanceof NetWork || !Intrinsics.areEqual(((ClientBomb)gameEvent).getPlayerPlacedName(), "local")) break block16;
                }
                Player winner = null;
                do {
                    Position position;
                    if (this.game.getCurrent() instanceof Bot) {
                        DelayerService.INSTANCE.botDelay();
                        position = BoardService.INSTANCE.getRandomValidNextPosition(this.game);
                    } else {
                        position = ((ClientBomb)gameEvent).getPosition();
                    }
                    Position position2 = position;
                    GameEvent newUpdate = GameProgressService.INSTANCE.playOnClick(this.game, position2);
                    this.sendGameUpdateToAll(newUpdate);
                    winner = GameService.INSTANCE.winner(this.game);
                } while (this.game.getCurrent() instanceof Bot && winner == null);
                Player player = winner;
                if (player != null) {
                    Player it = player;
                    boolean bl = false;
                    this.sendGameUpdateToAll(new GameFinish(it.getName(), it.getColor()));
                }
                break block16;
            }
            if (gameEvent2 instanceof PlayerDisconnect) {
                if (this.hasGameStarted) {
                    this.netWorkConnector.removePlayer(((PlayerDisconnect)gameEvent).getPlayerToLeave());
                } else {
                    this.updateNetWorkNumber.invoke(((PlayerDisconnect)gameEvent).getNumberOfNetworkPlayers());
                }
                this.sendGameUpdateToAll(gameEvent);
            } else if (gameEvent2 instanceof AfterDisconnect) {
                Iterable $this$forEach$iv = ((AfterDisconnect)gameEvent).getAllChanged();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Position it = (Position)element$iv;
                    boolean bl = false;
                    this.game.getBoard().setFigure(it, EmptyFigure.INSTANCE);
                }
                if (((AfterDisconnect)gameEvent).isCurrent()) {
                    this.game.startNextRound();
                }
                this.sendGameUpdateToAll(gameEvent);
            } else if (gameEvent2 instanceof StartingMenuUpdate) {
                BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gameEvent, null){
                    int label;
                    final /* synthetic */ Server this$0;
                    final /* synthetic */ GameEvent $gameEvent;
                    {
                        this.this$0 = $receiver;
                        this.$gameEvent = $gameEvent;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                Server.access$sendEventToAllNetworkClients(this.this$0, this.$gameEvent);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
        }
    }

    private final void sendGameUpdateToAll(GameEvent gameEvent) {
        Thread updateLocal = new Thread(() -> Server.sendGameUpdateToAll$lambda$2(this, gameEvent));
        updateLocal.start();
        Thread updateNetWorkPlayers = new Thread(() -> Server.sendGameUpdateToAll$lambda$3(this, gameEvent));
        updateNetWorkPlayers.start();
        updateLocal.join();
    }

    private final void sendEventToAllNetworkClients(GameEvent gameEvent) {
        this.netWorkConnector.sendToAllNetWorkPlayers(gameEvent);
    }

    @NotNull
    public final List<String> getNetworkPlayerNames() {
        return this.netWorkConnector.getNetworkPlayerNames();
    }

    public final void createGame(@NotNull JFrame frame, @NotNull BoardInitializeData boardData) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(boardData, "boardData");
        this.hasGameStarted = true;
        this.game = GameFactory.INSTANCE.create(boardData);
        this.game.getPlayers().get(0).setCurrentPlayer(true);
        this.boardGraphicalUi.bind(frame, (Function1<? super GameEvent, Unit>)new Function1<GameEvent, Unit>((Object)this){

            public final void invoke(@NotNull GameEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Server)this.receiver).handlePacket(p0);
            }
        });
        this.sendGameUpdateToAll(new Init(this.game.getPlayers(), BoardService.INSTANCE.getWalls(this.game.getBoard()), this.game.getBoard().getDimension()));
        GameEvent gameEvent = GameProgressService.INSTANCE.start(this.game);
        if (gameEvent != null) {
            this.sendGameUpdateToAll(gameEvent);
        }
    }

    private final Player getCurrentPlayer() {
        return this.game.getCurrent();
    }

    public final void setServerToConnector() {
        this.netWorkConnector.bind((Function1<? super GameEvent, Unit>)new Function1<GameEvent, Unit>((Object)this){

            public final void invoke(@NotNull GameEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((Server)this.receiver).handlePacket(p0);
            }
        }, (Function0<? extends Player>)new Function0<Player>((Object)this){

            @Nullable
            public final Player invoke() {
                return Server.access$getCurrentPlayer((Server)this.receiver);
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Server.access$getHasGameStarted$p(this.this$0);
            }
        });
    }

    public final void resetPlayers() {
        this.netWorkConnector.restePlayers();
    }

    public final boolean hasGameStarted() {
        return this.hasGameStarted;
    }

    public final void stopGameRunningFlag() {
        this.hasGameStarted = false;
    }

    private static final void sendGameUpdateToAll$lambda$2(Server this$0, GameEvent $gameEvent) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($gameEvent, "$gameEvent");
        this$0.boardGraphicalUi.onFigureChanged($gameEvent);
    }

    private static final void sendGameUpdateToAll$lambda$3(Server this$0, GameEvent $gameEvent) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($gameEvent, "$gameEvent");
        this$0.sendEventToAllNetworkClients($gameEvent);
    }

    public static final /* synthetic */ Player access$getCurrentPlayer(Server $this) {
        return $this.getCurrentPlayer();
    }

    public static final /* synthetic */ boolean access$getHasGameStarted$p(Server $this) {
        return $this.hasGameStarted;
    }

    public static final /* synthetic */ void access$sendEventToAllNetworkClients(Server $this, GameEvent gameEvent) {
        $this.sendEventToAllNetworkClients(gameEvent);
    }
}

