/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSystemSource;

@API(status=API.Status.STABLE, since="1.0")
public class FileSource
implements FileSystemSource {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final FilePosition filePosition;

    public static FileSource from(File file2) {
        return new FileSource(file2);
    }

    public static FileSource from(File file2, FilePosition filePosition) {
        return new FileSource(file2, filePosition);
    }

    private FileSource(File file2) {
        this(file2, null);
    }

    private FileSource(File file2, FilePosition filePosition) {
        Preconditions.notNull(file2, "file must not be null");
        try {
            this.file = file2.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new JUnitException("Failed to retrieve canonical path for file: " + file2, ex);
        }
        this.filePosition = filePosition;
    }

    @Override
    public final URI getUri() {
        return this.getFile().toURI();
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSource that = (FileSource)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("file", this.file).append("filePosition", this.filePosition).toString();
    }
}

