/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.reporting;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public final class ReportEntry {
    private final LocalDateTime timestamp = LocalDateTime.now();
    private final Map<String, String> keyValuePairs = new LinkedHashMap<String, String>();

    @API(status=API.Status.DEPRECATED, since="5.8")
    @Deprecated
    public ReportEntry() {
    }

    public static ReportEntry from(Map<String, String> keyValuePairs) {
        Preconditions.notNull(keyValuePairs, "keyValuePairs must not be null");
        ReportEntry reportEntry = new ReportEntry();
        keyValuePairs.forEach(reportEntry::add);
        return reportEntry;
    }

    public static ReportEntry from(String key2, String value) {
        ReportEntry reportEntry = new ReportEntry();
        reportEntry.add(key2, value);
        return reportEntry;
    }

    private void add(String key2, String value) {
        Preconditions.notBlank(key2, "key must not be null or blank");
        Preconditions.notBlank(value, "value must not be null or blank");
        this.keyValuePairs.put(key2, value);
    }

    public final Map<String, String> getKeyValuePairs() {
        return Collections.unmodifiableMap(this.keyValuePairs);
    }

    public final LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        ToStringBuilder builder2 = new ToStringBuilder(this);
        builder2.append("timestamp", this.timestamp);
        this.keyValuePairs.forEach(builder2::append);
        return builder2.toString();
    }
}

