/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FilePosition;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.NestedMethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.STABLE, since="1.0")
public final class DiscoverySelectors {
    private DiscoverySelectors() {
    }

    public static UriSelector selectUri(String uri2) {
        Preconditions.notBlank(uri2, "URI must not be null or blank");
        try {
            return new UriSelector(new URI(uri2));
        }
        catch (URISyntaxException ex) {
            throw new PreconditionViolationException("Failed to create a java.net.URI from: " + uri2, ex);
        }
    }

    public static UriSelector selectUri(URI uri2) {
        Preconditions.notNull(uri2, "URI must not be null");
        return new UriSelector(uri2);
    }

    public static FileSelector selectFile(String path) {
        return DiscoverySelectors.selectFile(path, null);
    }

    public static FileSelector selectFile(File file2) {
        return DiscoverySelectors.selectFile(file2, null);
    }

    public static FileSelector selectFile(String path, FilePosition position) {
        Preconditions.notBlank(path, "File path must not be null or blank");
        return new FileSelector(path, position);
    }

    public static FileSelector selectFile(File file2, FilePosition position) {
        Preconditions.notNull(file2, "File must not be null");
        Preconditions.condition(file2.isFile(), () -> String.format("The supplied java.io.File [%s] must represent an existing file", file2));
        try {
            return new FileSelector(file2.getCanonicalPath(), position);
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for file: " + file2, ex);
        }
    }

    public static DirectorySelector selectDirectory(String path) {
        Preconditions.notBlank(path, "Directory path must not be null or blank");
        return new DirectorySelector(path);
    }

    public static DirectorySelector selectDirectory(File directory) {
        Preconditions.notNull(directory, "Directory must not be null");
        Preconditions.condition(directory.isDirectory(), () -> String.format("The supplied java.io.File [%s] must represent an existing directory", directory));
        try {
            return new DirectorySelector(directory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for directory: " + directory, ex);
        }
    }

    public static List<ClasspathRootSelector> selectClasspathRoots(Set<Path> classpathRoots) {
        Preconditions.notNull(classpathRoots, "classpathRoots must not be null");
        return classpathRoots.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri).map(ClasspathRootSelector::new).collect(CollectionUtils.toUnmodifiableList());
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName) {
        return DiscoverySelectors.selectClasspathResource(classpathResourceName, null);
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName, FilePosition position) {
        Preconditions.notBlank(classpathResourceName, "Classpath resource name must not be null or blank");
        return new ClasspathResourceSelector(classpathResourceName, position);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1")
    public static ModuleSelector selectModule(String moduleName) {
        Preconditions.notBlank(moduleName, "Module name must not be null or blank");
        return new ModuleSelector(moduleName.trim());
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1")
    public static List<ModuleSelector> selectModules(Set<String> moduleNames) {
        Preconditions.notNull(moduleNames, "Module names must not be null");
        Preconditions.containsNoNullElements(moduleNames, "Individual module name must not be null");
        return moduleNames.stream().map(DiscoverySelectors::selectModule).collect(CollectionUtils.toUnmodifiableList());
    }

    public static PackageSelector selectPackage(String packageName) {
        Preconditions.notNull(packageName, "Package name must not be null");
        Preconditions.condition(packageName.isEmpty() || !packageName.trim().isEmpty(), "Package name must not contain only whitespace");
        return new PackageSelector(packageName.trim());
    }

    public static ClassSelector selectClass(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return new ClassSelector(clazz);
    }

    public static ClassSelector selectClass(String className) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        return new ClassSelector(className);
    }

    public static MethodSelector selectMethod(String fullyQualifiedMethodName) throws PreconditionViolationException {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        return DiscoverySelectors.selectMethod(methodParts[0], methodParts[1], methodParts[2]);
    }

    public static MethodSelector selectMethod(String className, String methodName) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new MethodSelector(className, methodName);
    }

    public static MethodSelector selectMethod(String className, String methodName, String methodParameterTypes) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new MethodSelector(className, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new MethodSelector(javaClass, methodName);
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName, String methodParameterTypes) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new MethodSelector(javaClass, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, Method method2) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notNull(method2, "Method must not be null");
        return new MethodSelector(javaClass, method2);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedClassSelector selectNestedClass(List<Class<?>> enclosingClasses, Class<?> nestedClass) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        return new NestedClassSelector(enclosingClasses, nestedClass);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedClassSelector selectNestedClass(List<String> enclosingClassNames, String nestedClassName) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        return new NestedClassSelector(enclosingClassNames, nestedClassName);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<String> enclosingClassNames, String nestedClassName, String methodName) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new NestedMethodSelector(enclosingClassNames, nestedClassName, methodName);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<String> enclosingClassNames, String nestedClassName, String methodName, String methodParameterTypes) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new NestedMethodSelector(enclosingClassNames, nestedClassName, methodName, methodParameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new NestedMethodSelector(enclosingClasses, nestedClass, methodName);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, String methodParameterTypes) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new NestedMethodSelector(enclosingClasses, nestedClass, methodName, methodParameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method2) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notNull(method2, "Method must not be null");
        return new NestedMethodSelector(enclosingClasses, nestedClass, method2);
    }

    public static UniqueIdSelector selectUniqueId(UniqueId uniqueId) {
        Preconditions.notNull(uniqueId, "UniqueId must not be null");
        return new UniqueIdSelector(uniqueId);
    }

    public static UniqueIdSelector selectUniqueId(String uniqueId) {
        Preconditions.notBlank(uniqueId, "Unique ID must not be null or blank");
        return new UniqueIdSelector(UniqueId.parse(uniqueId));
    }
}

