/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

class ClassFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(ClassFileVisitor.class);
    static final String CLASS_FILE_SUFFIX = ".class";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info.class";
    private static final String MODULE_INFO_FILE_NAME = "module-info.class";
    private final Consumer<Path> classFileConsumer;

    ClassFileVisitor(Consumer<Path> classFileConsumer) {
        this.classFileConsumer = classFileConsumer;
    }

    @Override
    public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes2) {
        if (ClassFileVisitor.isNotPackageInfo(file2) && ClassFileVisitor.isNotModuleInfo(file2) && ClassFileVisitor.isClassFile(file2)) {
            this.classFileConsumer.accept(file2);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file2, IOException ex) {
        logger.warn(ex, () -> "I/O error visiting file: " + file2);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
        if (ex != null) {
            logger.warn(ex, () -> "I/O error visiting directory: " + dir);
        }
        return FileVisitResult.CONTINUE;
    }

    private static boolean isNotPackageInfo(Path path) {
        return !path.endsWith(PACKAGE_INFO_FILE_NAME);
    }

    private static boolean isNotModuleInfo(Path path) {
        return !path.endsWith(MODULE_INFO_FILE_NAME);
    }

    private static boolean isClassFile(Path file2) {
        return file2.getFileName().toString().endsWith(CLASS_FILE_SUFFIX);
    }
}

