/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.fixed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ColumnMap;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.NormalizedString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParsingContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParsingContextWrapper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.Record;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.RecordFactory;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.record.RecordMetaData;
import org.junit.jupiter.params.shadow.com.univocity.parsers.fixed.FieldAlignment;
import org.junit.jupiter.params.shadow.com.univocity.parsers.fixed.FixedWidthFields;
import org.junit.jupiter.params.shadow.com.univocity.parsers.fixed.FixedWidthFormat;

class Lookup {
    final char[] value;
    final int[] lengths;
    final FieldAlignment[] alignments;
    final boolean[] ignore;
    final Boolean[] keepPaddingFlags;
    final char[] paddings;
    final NormalizedString[] fieldNames;
    final char wildcard;
    Context context;

    Lookup(String value, FixedWidthFields config2, FixedWidthFormat format) {
        this.value = value.toCharArray();
        this.lengths = config2.getAllLengths();
        this.alignments = config2.getFieldAlignments();
        this.fieldNames = config2.getFieldNames();
        this.paddings = config2.getFieldPaddings(format);
        this.wildcard = format.getLookupWildcard();
        this.ignore = config2.getFieldsToIgnore();
        this.keepPaddingFlags = config2.getKeepPaddingFlags();
    }

    void initializeLookupContext(ParsingContext context, NormalizedString[] headersToUse) {
        final String[] headers2 = NormalizedString.toArray(headersToUse);
        this.context = new ParsingContextWrapper(context){
            RecordFactory recordFactory;
            final ColumnMap columnMap;
            {
                super(x0);
                this.columnMap = new ColumnMap(this, null);
            }

            @Override
            public String[] headers() {
                return headers2;
            }

            @Override
            public int indexOf(String header) {
                return this.columnMap.indexOf(header);
            }

            @Override
            public int indexOf(Enum<?> header) {
                return this.columnMap.indexOf(header);
            }

            @Override
            public Record toRecord(String[] row) {
                if (this.recordFactory == null) {
                    this.recordFactory = new RecordFactory(this);
                }
                return this.recordFactory.newRecord(row);
            }

            @Override
            public RecordMetaData recordMetaData() {
                if (this.recordFactory == null) {
                    this.recordFactory = new RecordFactory(this);
                }
                return this.recordFactory.getRecordMetaData();
            }
        };
    }

    boolean matches(char[] lookup2) {
        if (this.value.length > lookup2.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            char ch = this.value[i2];
            if (ch == this.wildcard || ch == lookup2[i2]) continue;
            return false;
        }
        return true;
    }

    static void registerLookahead(String lookup2, FixedWidthFields lengths, Map<String, FixedWidthFields> map2) {
        Lookup.registerLookup("ahead", lookup2, lengths, map2);
    }

    static void registerLookbehind(String lookup2, FixedWidthFields lengths, Map<String, FixedWidthFields> map2) {
        Lookup.registerLookup("behind", lookup2, lengths, map2);
    }

    private static void registerLookup(String direction, String lookup2, FixedWidthFields lengths, Map<String, FixedWidthFields> map2) {
        if (lookup2 == null) {
            throw new IllegalArgumentException("Look" + direction + " value cannot be null");
        }
        if (lengths == null) {
            throw new IllegalArgumentException("Lengths of fields associated to look" + direction + " value '" + lookup2 + "' cannot be null");
        }
        map2.put(lookup2, lengths);
    }

    static Lookup[] getLookupFormats(Map<String, FixedWidthFields> map2, FixedWidthFormat format) {
        if (map2.isEmpty()) {
            return null;
        }
        Lookup[] out2 = new Lookup[map2.size()];
        int i2 = 0;
        for (Map.Entry<String, FixedWidthFields> e : map2.entrySet()) {
            out2[i2++] = new Lookup(e.getKey(), e.getValue(), format);
        }
        Arrays.sort(out2, new Comparator<Lookup>(){

            @Override
            public int compare(Lookup o1, Lookup o2) {
                return o1.value.length < o2.value.length ? 1 : (o1.value.length == o2.value.length ? 0 : -1);
            }
        });
        return out2;
    }

    static int calculateMaxLookupLength(Lookup[] ... lookupArrays) {
        int max = 0;
        for (Lookup[] lookups : lookupArrays) {
            if (lookups == null) continue;
            for (Lookup lookup2 : lookups) {
                if (max >= lookup2.value.length) continue;
                max = lookup2.value.length;
            }
        }
        return max;
    }

    static int[] calculateMaxFieldLengths(FixedWidthFields fieldLengths, Map<String, FixedWidthFields> lookaheadFormats, Map<String, FixedWidthFields> lookbehindFormats) {
        ArrayList<int[]> allLengths = new ArrayList<int[]>();
        if (fieldLengths != null) {
            allLengths.add(fieldLengths.getFieldLengths());
        }
        for (FixedWidthFields lengths : lookaheadFormats.values()) {
            allLengths.add(lengths.getFieldLengths());
        }
        for (FixedWidthFields lengths : lookbehindFormats.values()) {
            allLengths.add(lengths.getFieldLengths());
        }
        if (allLengths.isEmpty()) {
            throw new IllegalStateException("Cannot determine field lengths to use.");
        }
        int lastColumn = -1;
        for (int[] lengths : allLengths) {
            if (lastColumn >= lengths.length) continue;
            lastColumn = lengths.length;
        }
        int[] out2 = new int[lastColumn];
        Arrays.fill(out2, 0);
        for (int[] lengths : allLengths) {
            for (int i2 = 0; i2 < lastColumn; ++i2) {
                int length;
                if (i2 >= lengths.length || out2[i2] >= (length = lengths[i2])) continue;
                out2[i2] = length;
            }
        }
        return out2;
    }
}

