/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.conversions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.FormattedConversion;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.ObjectConversion;

public abstract class NumericConversion<T extends Number>
extends ObjectConversion<T>
implements FormattedConversion<DecimalFormat> {
    private DecimalFormat[] formatters = new DecimalFormat[0];
    private String[] formats = new String[0];
    private final ParsePosition position = new ParsePosition(0);
    private Class<? extends Number> numberType = Number.class;

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, String ... numericFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formats", numericFormats);
        this.formats = (String[])numericFormats.clone();
        this.formatters = new DecimalFormat[numericFormats.length];
        for (int i2 = 0; i2 < numericFormats.length; ++i2) {
            String numericFormat = numericFormats[i2];
            this.formatters[i2] = new DecimalFormat(numericFormat);
            this.configureFormatter(this.formatters[i2]);
        }
    }

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, DecimalFormat ... numericFormatters) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formatters", numericFormatters);
        this.formatters = (DecimalFormat[])numericFormatters.clone();
        this.formats = new String[numericFormatters.length];
        for (int i2 = 0; i2 < numericFormatters.length; ++i2) {
            this.formats[i2] = numericFormatters[i2].toPattern();
        }
    }

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
    }

    public NumericConversion(String ... numericFormats) {
        this((null), (String)null, numericFormats);
    }

    public NumericConversion(DecimalFormat ... numericFormatters) {
        this((null), (String)null, numericFormatters);
    }

    public NumericConversion() {
    }

    public Class<? extends Number> getNumberType() {
        return this.numberType;
    }

    public void setNumberType(Class<? extends Number> numberType) {
        this.numberType = numberType;
    }

    public DecimalFormat[] getFormatterObjects() {
        return this.formatters;
    }

    protected abstract void configureFormatter(DecimalFormat var1);

    @Override
    protected T fromString(String input2) {
        for (int i2 = 0; i2 < this.formatters.length; ++i2) {
            this.position.setIndex(0);
            Number out2 = this.formatters[i2].parse(input2, this.position);
            if (this.formatters.length != 1 && this.position.getIndex() != input2.length()) continue;
            if (out2 == null || this.numberType == Number.class) {
                return (T)out2;
            }
            if (this.numberType == Double.class) {
                return (T)Double.valueOf(out2.doubleValue());
            }
            if (this.numberType == Float.class) {
                return (T)Float.valueOf(out2.floatValue());
            }
            if (this.numberType == BigDecimal.class) {
                if (out2 instanceof BigDecimal) {
                    return (T)out2;
                }
                return (T)new BigDecimal(String.valueOf(out2));
            }
            if (this.numberType == BigInteger.class) {
                if (out2 instanceof BigInteger) {
                    return (T)out2;
                }
                return (T)BigInteger.valueOf(out2.longValue());
            }
            if (this.numberType == Long.class) {
                return (T)Long.valueOf(out2.longValue());
            }
            if (this.numberType == Integer.class) {
                return (T)Integer.valueOf(out2.intValue());
            }
            if (this.numberType == Short.class) {
                return (T)Short.valueOf(out2.shortValue());
            }
            if (this.numberType == Byte.class) {
                return (T)Byte.valueOf(out2.byteValue());
            }
            return (T)out2;
        }
        DataProcessingException exception = new DataProcessingException("Cannot parse '{value}' as a valid number. Supported formats are: " + Arrays.toString(this.formats));
        exception.setValue(input2);
        throw exception;
    }

    @Override
    public String revert(T input2) {
        if (input2 == null) {
            return super.revert((Object)null);
        }
        for (DecimalFormat formatter : this.formatters) {
            try {
                return formatter.format(input2);
            }
            catch (Throwable ex) {
            }
        }
        DataProcessingException exception = new DataProcessingException("Cannot format '{value}'. No valid formatters were defined.");
        exception.setValue(input2);
        throw exception;
    }

    public void addFormat(String format, String ... formatOptions) {
        DecimalFormat formatter = new DecimalFormat(format);
        this.configureFormatter(formatter);
        AnnotationHelper.applyFormatSettings(formatter, formatOptions);
        this.formats = Arrays.copyOf(this.formats, this.formats.length + 1);
        this.formatters = Arrays.copyOf(this.formatters, this.formatters.length + 1);
        this.formats[this.formats.length - 1] = format;
        this.formatters[this.formatters.length - 1] = formatter;
    }
}

