/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FieldSet<T>
implements Cloneable {
    private List<T> fields = new ArrayList<T>();
    private List<FieldSet<T>> wrappedFieldSets;

    public FieldSet() {
        this.wrappedFieldSets = Collections.emptyList();
    }

    public FieldSet(List<FieldSet<T>> wrappedFieldSets) {
        this.wrappedFieldSets = wrappedFieldSets;
        if (this.wrappedFieldSets.contains(this)) {
            this.wrappedFieldSets.remove(this);
        }
    }

    public List<T> get() {
        return new ArrayList<T>(this.fields);
    }

    public FieldSet<T> set(T ... fields2) {
        this.fields.clear();
        this.add(fields2);
        for (FieldSet<T> wrapped : this.wrappedFieldSets) {
            wrapped.set(fields2);
        }
        return this;
    }

    public FieldSet<T> add(T ... fields2) {
        for (T field : fields2) {
            this.addElement(field);
        }
        for (FieldSet<T> wrapped : this.wrappedFieldSets) {
            wrapped.add(fields2);
        }
        return this;
    }

    private void addElement(T field) {
        this.fields.add(field);
    }

    public FieldSet<T> set(Collection<T> fields2) {
        this.fields.clear();
        this.add(fields2);
        for (FieldSet<T> wrapped : this.wrappedFieldSets) {
            wrapped.set(fields2);
        }
        return this;
    }

    public FieldSet<T> add(Collection<T> fields2) {
        for (T t : fields2) {
            this.addElement(t);
        }
        for (FieldSet fieldSet : this.wrappedFieldSets) {
            fieldSet.add(fields2);
        }
        return this;
    }

    public FieldSet<T> remove(T ... fields2) {
        for (T field : fields2) {
            this.fields.remove(field);
        }
        for (FieldSet<T> wrapped : this.wrappedFieldSets) {
            wrapped.remove(fields2);
        }
        return this;
    }

    public FieldSet<T> remove(Collection<T> fields2) {
        this.fields.removeAll(fields2);
        for (FieldSet<T> wrapped : this.wrappedFieldSets) {
            wrapped.remove(fields2);
        }
        return this;
    }

    public String describe() {
        return "field selection: " + this.fields.toString();
    }

    public String toString() {
        return this.fields.toString();
    }

    public FieldSet<T> clone() {
        try {
            FieldSet out2 = (FieldSet)super.clone();
            out2.fields = new ArrayList<T>(this.fields);
            if (this.wrappedFieldSets != null) {
                out2.wrappedFieldSets = new ArrayList<FieldSet<T>>();
                for (FieldSet<T> fieldSet : this.wrappedFieldSets) {
                    out2.wrappedFieldSets.add((FieldSet<T>)fieldSet.clone());
                }
            }
            return out2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

