/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractException;

public class TextWritingException
extends AbstractException {
    private static final long serialVersionUID = 7198462597717255519L;
    private final long recordCount;
    private final Object[] recordData;
    private final String recordCharacters;

    private TextWritingException(String message2, long recordCount, Object[] row, String recordCharacters, Throwable cause) {
        super(message2, cause);
        this.recordCount = recordCount;
        this.recordData = row;
        this.recordCharacters = recordCharacters;
    }

    public TextWritingException(String message2, long recordCount, String recordCharacters, Throwable cause) {
        this(message2, recordCount, null, recordCharacters, cause);
    }

    public TextWritingException(String message2, long recordCount, Object[] row, Throwable cause) {
        this(message2, recordCount, row, null, cause);
    }

    public TextWritingException(String message2) {
        this(message2, 0L, null, null, null);
    }

    public TextWritingException(Throwable cause) {
        this(cause != null ? cause.getMessage() : null, 0L, null, null, cause);
    }

    public TextWritingException(String message2, long line, Object[] row) {
        this(message2, line, row, null);
    }

    public TextWritingException(String message2, long line, String recordCharacters) {
        this(message2, line, null, recordCharacters, null);
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public Object[] getRecordData() {
        return this.restrictContent(this.recordData);
    }

    public String getRecordCharacters() {
        if (this.errorContentLength == 0) {
            return null;
        }
        return this.recordCharacters;
    }

    @Override
    protected String getDetails() {
        String details = "";
        details = TextWritingException.printIfNotEmpty(details, "recordCount", this.recordCount);
        details = TextWritingException.printIfNotEmpty(details, "recordData", this.restrictContent(this.recordData));
        details = TextWritingException.printIfNotEmpty(details, "recordCharacters", this.restrictContent(this.recordCharacters));
        return details;
    }

    @Override
    protected String getErrorDescription() {
        return "Error writing data";
    }
}

