/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.NormalizedString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.BomInput;

public class ArgumentUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final NormalizedString[] EMPTY_NORMALIZED_STRING_ARRAY = new NormalizedString[0];

    public static <T> void notEmpty(String argDescription, T ... args2) {
        if (args2 == null) {
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
        if (args2.length == 0) {
            throw new IllegalArgumentException(argDescription + " must not be empty");
        }
    }

    public static <T> void noNulls(String argDescription, T ... args2) {
        ArgumentUtils.notEmpty(argDescription, args2);
        for (T arg : args2) {
            if (arg != null) continue;
            if (args2.length > 0) {
                throw new IllegalArgumentException(argDescription + " must not contain nulls");
            }
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
    }

    public static int indexOf(NormalizedString[] array, NormalizedString element, FieldSelector fieldSelector) {
        int index = ArgumentUtils.indexOf(array, element);
        if (fieldSelector == null || index == -1) {
            return index;
        }
        int[] indexes = fieldSelector.getFieldIndexes(array);
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (indexes[i2] != index) continue;
            return i2;
        }
        return -1;
    }

    public static int[] indexesOf(Object[] array, Object element) {
        int[] tmp = new int[]{};
        int i2 = 0;
        int o = 0;
        while (i2 < array.length && (i2 = ArgumentUtils.indexOf(array, element, i2)) != -1) {
            tmp = Arrays.copyOf(tmp, tmp.length + 1);
            tmp[o++] = i2++;
        }
        return tmp;
    }

    public static int indexOf(Object[] array, Object element) {
        return ArgumentUtils.indexOf(array, element, 0);
    }

    public static int indexOf(char[] array, char element, int from) {
        for (int i2 = from; i2 < array.length; ++i2) {
            if (array[i2] != element) continue;
            return i2;
        }
        return -1;
    }

    private static int indexOf(Object[] array, Object element, int from) {
        if (array == null) {
            throw new NullPointerException("Null array");
        }
        if (element == null) {
            for (int i2 = from; i2 < array.length; ++i2) {
                if (array[i2] != null) continue;
                return i2;
            }
        } else {
            if (element.getClass() != array.getClass().getComponentType()) {
                throw new IllegalStateException("a");
            }
            if (element instanceof String && array instanceof String[]) {
                for (int i3 = from; i3 < array.length; ++i3) {
                    String e = String.valueOf(array[i3]);
                    if (!element.toString().equalsIgnoreCase(e)) continue;
                    return i3;
                }
            } else {
                for (int i4 = from; i4 < array.length; ++i4) {
                    if (!element.equals(array[i4])) continue;
                    return i4;
                }
            }
        }
        return -1;
    }

    public static Object[] findMissingElements(Object[] array, Collection<?> elements) {
        return ArgumentUtils.findMissingElements(array, elements.toArray());
    }

    public static Object[] findMissingElements(Object[] array, Object[] elements) {
        ArrayList<Object> out2 = new ArrayList<Object>();
        for (Object element : elements) {
            if (ArgumentUtils.indexOf(array, element) != -1) continue;
            out2.add(element);
        }
        return out2.toArray();
    }

    public static Writer newWriter(OutputStream output2) {
        return ArgumentUtils.newWriter(output2, (Charset)null);
    }

    public static Writer newWriter(OutputStream output2, String encoding) {
        return ArgumentUtils.newWriter(output2, Charset.forName(encoding));
    }

    public static Writer newWriter(OutputStream output2, Charset encoding) {
        if (encoding != null) {
            return new OutputStreamWriter(output2, encoding);
        }
        return new OutputStreamWriter(output2);
    }

    public static Writer newWriter(File file2) {
        return ArgumentUtils.newWriter(file2, (Charset)null);
    }

    public static Writer newWriter(File file2, String encoding) {
        return ArgumentUtils.newWriter(file2, Charset.forName(encoding));
    }

    public static Writer newWriter(File file2, Charset encoding) {
        FileOutputStream os;
        if (!file2.exists()) {
            File parent = file2.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            try {
                file2.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to create file '" + file2.getAbsolutePath() + "', please ensure your application has permission to create files in that path", e);
            }
        }
        try {
            os = new FileOutputStream(file2);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return ArgumentUtils.newWriter((OutputStream)os, encoding);
    }

    public static Reader newReader(InputStream input2) {
        return ArgumentUtils.newReader(input2, (Charset)null);
    }

    public static Reader newReader(InputStream input2, String encoding) {
        return ArgumentUtils.newReader(input2, encoding == null ? (Charset)null : Charset.forName(encoding));
    }

    public static Reader newReader(InputStream input2, Charset encoding) {
        if (encoding == null) {
            BomInput bomInput = new BomInput(input2);
            if (bomInput.getEncoding() != null) {
                encoding = bomInput.getCharset();
            }
            if (bomInput.hasBytesStored()) {
                input2 = bomInput;
            }
        }
        if (encoding != null) {
            return new InputStreamReader(input2, encoding);
        }
        return new InputStreamReader(input2);
    }

    public static Reader newReader(File file2) {
        return ArgumentUtils.newReader(file2, (Charset)null);
    }

    public static Reader newReader(File file2, String encoding) {
        return ArgumentUtils.newReader(file2, Charset.forName(encoding));
    }

    public static Reader newReader(File file2, Charset encoding) {
        FileInputStream input2;
        try {
            input2 = new FileInputStream(file2);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return ArgumentUtils.newReader((InputStream)input2, encoding);
    }

    public static String[] toArray(List<Enum> enums) {
        String[] out2 = new String[enums.size()];
        for (int i2 = 0; i2 < out2.length; ++i2) {
            out2[i2] = enums.get(i2).toString();
        }
        return out2;
    }

    public static int[] toIntArray(Collection<Integer> ints) {
        int[] out2 = new int[ints.size()];
        int i2 = 0;
        for (Integer boxed : ints) {
            out2[i2++] = boxed;
        }
        return out2;
    }

    public static char[] toCharArray(Collection<Character> characters) {
        char[] out2 = new char[characters.size()];
        int i2 = 0;
        for (Character boxed : characters) {
            out2[i2++] = boxed.charValue();
        }
        return out2;
    }

    public static String restrictContent(int length, CharSequence content2) {
        if (content2 == null) {
            return null;
        }
        if (length == 0) {
            return "<omitted>";
        }
        if (length == -1) {
            return ((Object)content2).toString();
        }
        int errorMessageStart = content2.length() - length;
        if (length > 0 && errorMessageStart > 0) {
            return "..." + ((Object)content2.subSequence(errorMessageStart, content2.length())).toString();
        }
        return ((Object)content2).toString();
    }

    public static String restrictContent(int length, Object content2) {
        if (content2 == null) {
            return null;
        }
        if (content2 instanceof Object[]) {
            return ArgumentUtils.restrictContent(length, Arrays.toString((Object[])content2));
        }
        return ArgumentUtils.restrictContent(length, String.valueOf(content2));
    }

    public static void throwUnchecked(Throwable error2) {
        ArgumentUtils.throwsUnchecked(error2);
    }

    private static <T extends Exception> void throwsUnchecked(Throwable toThrow) throws T {
        throw (Exception)toThrow;
    }

    public static byte[] toByteArray(int ... ints) {
        byte[] out2 = new byte[ints.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            out2[i2] = (byte)ints[i2];
        }
        return out2;
    }

    public static <T> T[] findDuplicates(T[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        HashSet<T> elements = new HashSet<T>(array.length);
        ArrayList<T> duplicates = new ArrayList<T>(1);
        for (T element : array) {
            if (!elements.contains(element)) {
                elements.add(element);
                continue;
            }
            duplicates.add(element);
        }
        return duplicates.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), duplicates.size()));
    }

    public static String trim(String input2, boolean left, boolean right) {
        int begin;
        if (input2.length() == 0 || !left && !right) {
            return input2;
        }
        for (begin = 0; left && begin < input2.length() && input2.charAt(begin) <= ' '; ++begin) {
        }
        if (begin == input2.length()) {
            return "";
        }
        int end2 = begin + input2.length() - 1;
        if (end2 >= input2.length()) {
            end2 = input2.length() - 1;
        }
        while (right && input2.charAt(end2) <= ' ') {
            --end2;
        }
        if (begin == end2) {
            return "";
        }
        if (begin == 0 && end2 == input2.length() - 1) {
            return input2;
        }
        return input2.substring(begin, end2 + 1);
    }

    public static String displayLineSeparators(String str, boolean addNewLine) {
        StringBuilder out2 = new StringBuilder();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char ch = str.charAt(i2);
            if (ch == '\r' || ch == '\n') {
                out2.append('[');
                out2.append(ch == '\r' ? "cr" : "lf");
                char next = '\u0000';
                if (i2 + 1 < str.length()) {
                    next = str.charAt(i2 + 1);
                    if (next != ch && (next == '\r' || next == '\n')) {
                        out2.append(next == '\r' ? "cr" : "lf");
                        ++i2;
                    } else {
                        next = '\u0000';
                    }
                }
                out2.append(']');
                if (!addNewLine) continue;
                out2.append(ch);
                if (next == '\u0000') continue;
                out2.append(next);
                continue;
            }
            out2.append(ch);
        }
        return out2.toString();
    }

    public static int[] removeAll(int[] array, int e) {
        if (array == null || array.length == 0) {
            return array;
        }
        int removeCount = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != e) continue;
            ++removeCount;
        }
        if (removeCount == 0) {
            return array;
        }
        int[] tmp = new int[array.length - removeCount];
        int j = 0;
        for (int i3 = 0; i3 < array.length; ++i3) {
            if (array[i3] == e) continue;
            tmp[j++] = array[i3];
        }
        return tmp;
    }
}

