/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.NullEnum;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

class EnumArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<EnumSource> {
    private EnumSource enumSource;

    EnumArgumentsProvider() {
    }

    @Override
    public void accept(EnumSource enumSource) {
        this.enumSource = enumSource;
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Set<Enum> constants = this.getEnumConstants(context);
        EnumSource.Mode mode = this.enumSource.mode();
        String[] declaredConstantNames = this.enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            Preconditions.condition(uniqueNames.size() == declaredConstantNames.length, () -> "Duplicate enum constant name(s) found in " + this.enumSource);
            mode.validate(this.enumSource, constants, uniqueNames);
            constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
        return constants.stream().map(xva$0 -> Arguments.of(xva$0));
    }

    private <E extends Enum<E>> Set<? extends E> getEnumConstants(ExtensionContext context) {
        Class<E> enumClass = this.determineEnumClass(context);
        return EnumSet.allOf(enumClass);
    }

    private <E extends Enum<E>> Class<E> determineEnumClass(ExtensionContext context) {
        Class<Enum> enumClass = this.enumSource.value();
        if (enumClass.equals(NullEnum.class)) {
            Method method2 = context.getRequiredTestMethod();
            Class<?>[] parameterTypes = method2.getParameterTypes();
            Preconditions.condition(parameterTypes.length > 0, () -> "Test method must declare at least one parameter: " + method2.toGenericString());
            Preconditions.condition(Enum.class.isAssignableFrom(parameterTypes[0]), () -> "First parameter must reference an Enum type (alternatively, use the annotation's 'value' attribute to specify the type explicitly): " + method2.toGenericString());
            enumClass = parameterTypes[0];
        }
        return enumClass;
    }
}

