/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.FallbackStringToObjectConverter;
import org.junit.jupiter.params.converter.SimpleArgumentConverter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
extends SimpleArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();
    private static final List<StringToObjectConverter> stringToObjectConverters = Collections.unmodifiableList(Arrays.asList(new StringToBooleanAndCharPrimitiveConverter(), new StringToNumericPrimitiveConverter(), new StringToEnumConverter(), new StringToJavaTimeConverter(), new StringToCommonJavaTypesConverter(), new FallbackStringToObjectConverter()));

    private DefaultArgumentConverter() {
    }

    @Override
    public Object convert(Object source2, Class<?> targetType) {
        if (source2 == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo(source2, targetType)) {
            return source2;
        }
        return this.convertToTargetType(source2, DefaultArgumentConverter.toWrapperType(targetType));
    }

    private Object convertToTargetType(Object source2, Class<?> targetType) {
        Optional<StringToObjectConverter> converter;
        if (source2 instanceof String && (converter = stringToObjectConverters.stream().filter(candidate -> candidate.canConvert(targetType)).findFirst()).isPresent()) {
            try {
                return converter.get().convert((String)source2, targetType);
            }
            catch (Exception ex) {
                if (ex instanceof ArgumentConversionException) {
                    throw (ArgumentConversionException)ex;
                }
                throw new ArgumentConversionException("Failed to convert String \"" + source2 + "\" to type " + targetType.getName(), ex);
            }
        }
        throw new ArgumentConversionException("No implicit conversion to convert object of type " + source2.getClass().getName() + " to type " + targetType.getName());
    }

    private static Class<?> toWrapperType(Class<?> targetType) {
        Class<?> wrapperType = ReflectionUtils.getWrapperType(targetType);
        return wrapperType != null ? wrapperType : targetType;
    }

    static interface StringToObjectConverter {
        public boolean canConvert(Class<?> var1);

        public Object convert(String var1, Class<?> var2) throws Exception;
    }

    private static class StringToBooleanAndCharPrimitiveConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToBooleanAndCharPrimitiveConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source2, Class<?> targetType) {
            return CONVERTERS.get(targetType).apply(source2);
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(Boolean.class, Boolean::valueOf);
            converters.put(Character.class, source2 -> {
                Preconditions.condition(source2.length() == 1, () -> "String must have length of 1: " + source2);
                return Character.valueOf(source2.charAt(0));
            });
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    private static class StringToNumericPrimitiveConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToNumericPrimitiveConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source2, Class<?> targetType) {
            return CONVERTERS.get(targetType).apply(source2.replace("_", ""));
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(Byte.class, Byte::decode);
            converters.put(Short.class, Short::decode);
            converters.put(Integer.class, Integer::decode);
            converters.put(Long.class, Long::decode);
            converters.put(Float.class, Float::valueOf);
            converters.put(Double.class, Double::valueOf);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    private static class StringToEnumConverter
    implements StringToObjectConverter {
        private StringToEnumConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return targetType.isEnum();
        }

        @Override
        public Object convert(String source2, Class<?> targetType) throws Exception {
            return this.valueOf(targetType, source2);
        }

        private Object valueOf(Class targetType, String source2) {
            return Enum.valueOf(targetType, source2);
        }
    }

    private static class StringToJavaTimeConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToJavaTimeConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source2, Class<?> targetType) throws Exception {
            return CONVERTERS.get(targetType).apply(source2);
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(Duration.class, Duration::parse);
            converters.put(Instant.class, Instant::parse);
            converters.put(LocalDate.class, LocalDate::parse);
            converters.put(LocalDateTime.class, LocalDateTime::parse);
            converters.put(LocalTime.class, LocalTime::parse);
            converters.put(MonthDay.class, MonthDay::parse);
            converters.put(OffsetDateTime.class, OffsetDateTime::parse);
            converters.put(OffsetTime.class, OffsetTime::parse);
            converters.put(Period.class, Period::parse);
            converters.put(Year.class, Year::parse);
            converters.put(YearMonth.class, YearMonth::parse);
            converters.put(ZonedDateTime.class, ZonedDateTime::parse);
            converters.put(ZoneId.class, ZoneId::of);
            converters.put(ZoneOffset.class, ZoneOffset::of);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    private static class StringToCommonJavaTypesConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToCommonJavaTypesConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source2, Class<?> targetType) throws Exception {
            return CONVERTERS.get(targetType).apply(source2);
        }

        private static Class<?> toClass(String type2) {
            return ReflectionUtils.tryToLoadClass(type2).getOrThrow(cause -> new ArgumentConversionException("Failed to convert String \"" + type2 + "\" to type " + Class.class.getName(), (Throwable)cause));
        }

        private static URL toURL(String url2) {
            try {
                return new URL(url2);
            }
            catch (MalformedURLException ex) {
                throw new ArgumentConversionException("Failed to convert String \"" + url2 + "\" to type " + URL.class.getName(), ex);
            }
        }

        static {
            HashMap<Class<UUID>, Function<String, Object>> converters = new HashMap<Class<UUID>, Function<String, Object>>();
            converters.put(Class.class, StringToCommonJavaTypesConverter::toClass);
            converters.put(File.class, File::new);
            converters.put(Charset.class, Charset::forName);
            converters.put(Path.class, x$0 -> Paths.get(x$0, new String[0]));
            converters.put(URI.class, URI::create);
            converters.put(URL.class, StringToCommonJavaTypesConverter::toURL);
            converters.put(BigDecimal.class, BigDecimal::new);
            converters.put(BigInteger.class, BigInteger::new);
            converters.put(Currency.class, Currency::getInstance);
            converters.put(Locale.class, Locale::new);
            converters.put(UUID.class, UUID::fromString);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }
}

