/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.extension.TimeoutConfiguration;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutInvocation;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.RuntimeUtils;

class TimeoutExtension
implements BeforeAllCallback,
BeforeEachCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(Timeout.class);
    private static final String TESTABLE_METHOD_TIMEOUT_KEY = "testable_method_timeout_from_annotation";
    private static final String GLOBAL_TIMEOUT_CONFIG_KEY = "global_timeout_config";
    private static final String ENABLED_MODE_VALUE = "enabled";
    private static final String DISABLED_MODE_VALUE = "disabled";
    private static final String DISABLED_ON_DEBUG_MODE_VALUE = "disabled_on_debug";

    TimeoutExtension() {
    }

    @Override
    public void beforeAll(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    private void readAndStoreTimeoutSoChildrenInheritIt(ExtensionContext context) {
        this.readTimeoutFromAnnotation(context.getElement()).ifPresent(timeout2 -> context.getStore(NAMESPACE).put(TESTABLE_METHOD_TIMEOUT_KEY, timeout2));
    }

    @Override
    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeAllMethodTimeout);
    }

    @Override
    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeEachMethodTimeout);
    }

    @Override
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestMethodTimeout);
    }

    @Override
    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestTemplateMethodTimeout);
    }

    @Override
    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.interceptTestableMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestFactoryMethodTimeout);
    }

    @Override
    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterEachMethodTimeout);
    }

    @Override
    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation2, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterAllMethodTimeout);
    }

    private void interceptLifecycleMethod(InvocationInterceptor.Invocation<Void> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout2 = this.readTimeoutFromAnnotation(Optional.of(invocationContext.getExecutable())).orElse(null);
        this.intercept(invocation2, invocationContext, extensionContext, timeout2, defaultTimeoutProvider);
    }

    private Optional<TimeoutDuration> readTimeoutFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(TimeoutDuration::from);
    }

    private <T> T interceptTestableMethod(InvocationInterceptor.Invocation<T> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout2 = extensionContext.getStore(NAMESPACE).get(TESTABLE_METHOD_TIMEOUT_KEY, TimeoutDuration.class);
        return this.intercept(invocation2, invocationContext, extensionContext, timeout2, defaultTimeoutProvider);
    }

    private <T> T intercept(InvocationInterceptor.Invocation<T> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration explicitTimeout, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout2 = explicitTimeout == null ? this.getDefaultTimeout(extensionContext, defaultTimeoutProvider) : explicitTimeout;
        return this.decorate(invocation2, invocationContext, extensionContext, timeout2).proceed();
    }

    private TimeoutDuration getDefaultTimeout(ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) {
        return ((Optional)defaultTimeoutProvider.apply(this.getGlobalTimeoutConfiguration(extensionContext))).orElse(null);
    }

    private TimeoutConfiguration getGlobalTimeoutConfiguration(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        return root.getStore(NAMESPACE).getOrComputeIfAbsent(GLOBAL_TIMEOUT_CONFIG_KEY, key2 -> new TimeoutConfiguration(root), TimeoutConfiguration.class);
    }

    private <T> InvocationInterceptor.Invocation<T> decorate(InvocationInterceptor.Invocation<T> invocation2, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration timeout2) {
        if (timeout2 == null || this.isTimeoutDisabled(extensionContext)) {
            return invocation2;
        }
        return new TimeoutInvocation<T>(invocation2, timeout2, this.getExecutor(extensionContext), () -> this.describe(invocationContext, extensionContext));
    }

    private String describe(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Method method2 = invocationContext.getExecutable();
        Optional<Class<?>> testClass = extensionContext.getTestClass();
        if (testClass.isPresent() && invocationContext.getTargetClass().equals(testClass.get())) {
            return String.format("%s(%s)", method2.getName(), ClassUtils.nullSafeToString(method2.getParameterTypes()));
        }
        return ReflectionUtils.getFullyQualifiedMethodName(invocationContext.getTargetClass(), method2);
    }

    private ScheduledExecutorService getExecutor(ExtensionContext extensionContext) {
        return extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent(ExecutorResource.class).get();
    }

    private boolean isTimeoutDisabled(ExtensionContext extensionContext) {
        Optional<String> mode = extensionContext.getConfigurationParameter("junit.jupiter.execution.timeout.mode");
        return mode.map(this::isTimeoutDisabled).orElse(false);
    }

    private boolean isTimeoutDisabled(String mode) {
        switch (mode) {
            case "enabled": {
                return false;
            }
            case "disabled": {
                return true;
            }
            case "disabled_on_debug": {
                return RuntimeUtils.isDebugMode();
            }
        }
        throw new ExtensionConfigurationException("Unsupported timeout mode: " + mode);
    }

    @FunctionalInterface
    private static interface TimeoutProvider
    extends Function<TimeoutConfiguration, Optional<TimeoutDuration>> {
    }

    private static class ExecutorResource
    implements ExtensionContext.Store.CloseableResource {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread2 = new Thread(runnable, "junit-jupiter-timeout-watcher");
            thread2.setPriority(10);
            return thread2;
        });

        ExecutorResource() {
        }

        ScheduledExecutorService get() {
            return this.executor;
        }

        @Override
        public void close() throws Throwable {
            this.executor.shutdown();
            boolean terminated = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!terminated) {
                this.executor.shutdownNow();
                throw new JUnitException("Scheduled executor could not be stopped in an orderly manner");
            }
        }
    }
}

