/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Timeout;
import org.junit.platform.commons.util.Preconditions;

class TimeoutDuration {
    private final long value;
    private final TimeUnit unit;

    static TimeoutDuration from(Timeout timeout2) {
        return new TimeoutDuration(timeout2.value(), timeout2.unit());
    }

    TimeoutDuration(long value, TimeUnit unit) {
        Preconditions.condition(value > 0L, () -> "timeout duration must be a positive number: " + value);
        this.value = value;
        this.unit = Preconditions.notNull(unit, "timeout unit must not be null");
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeoutDuration that = (TimeoutDuration)o;
        return this.value == that.value && this.unit == that.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit});
    }

    public String toString() {
        String label = this.unit.name().toLowerCase();
        if (this.value == 1L && label.endsWith("s")) {
            label = label.substring(0, label.length() - 1);
        }
        return this.value + " " + label;
    }
}

