/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ExtensionValuesStore;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.0")
public class NamespaceAwareStore
implements ExtensionContext.Store {
    private final ExtensionValuesStore valuesStore;
    private final ExtensionContext.Namespace namespace;

    public NamespaceAwareStore(ExtensionValuesStore valuesStore, ExtensionContext.Namespace namespace) {
        this.valuesStore = valuesStore;
        this.namespace = namespace;
    }

    @Override
    public Object get(Object key2) {
        Preconditions.notNull(key2, "key must not be null");
        return this.valuesStore.get(this.namespace, key2);
    }

    public <T> T get(Object key2, Class<T> requiredType) {
        Preconditions.notNull(key2, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.get(this.namespace, key2, requiredType);
    }

    @Override
    public <K, V> Object getOrComputeIfAbsent(K key2, Function<K, V> defaultCreator) {
        Preconditions.notNull(key2, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        return this.valuesStore.getOrComputeIfAbsent(this.namespace, key2, defaultCreator);
    }

    @Override
    public <K, V> V getOrComputeIfAbsent(K key2, Function<K, V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key2, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.getOrComputeIfAbsent(this.namespace, key2, defaultCreator, requiredType);
    }

    @Override
    public void put(Object key2, Object value) {
        Preconditions.notNull(key2, "key must not be null");
        this.valuesStore.put(this.namespace, key2, value);
    }

    @Override
    public Object remove(Object key2) {
        Preconditions.notNull(key2, "key must not be null");
        return this.valuesStore.remove(this.namespace, key2);
    }

    public <T> T remove(Object key2, Class<T> requiredType) {
        Preconditions.notNull(key2, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.remove(this.namespace, key2, requiredType);
    }
}

