/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertEquals {
    private AssertEquals() {
    }

    static void assertEquals(byte expected, byte actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(byte expected, byte actual, String message2) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(char expected, char actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(char expected, char actual, String message2) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)Character.valueOf(expected), (Object)Character.valueOf(actual), message2);
        }
    }

    static void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)Character.valueOf(expected), (Object)Character.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(double expected, double actual, String message2) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual, double delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(double expected, double actual, double delta, String message2) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(double expected, double actual, double delta, Supplier<String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(float expected, float actual, String message2) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual((Object)Float.valueOf(expected), (Object)Float.valueOf(actual), message2);
        }
    }

    static void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual((Object)Float.valueOf(expected), (Object)Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual, float delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(float expected, float actual, float delta, String message2) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertionUtils.failNotEqual((Object)Float.valueOf(expected), (Object)Float.valueOf(actual), message2);
        }
    }

    static void assertEquals(float expected, float actual, float delta, Supplier<String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertionUtils.failNotEqual((Object)Float.valueOf(expected), (Object)Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(short expected, short actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(short expected, short actual, String message2) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(int expected, int actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(int expected, int actual, String message2) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(long expected, long actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(long expected, long actual, String message2) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, message2);
        }
    }

    static void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertionUtils.failNotEqual((Object)expected, (Object)actual, messageSupplier);
        }
    }

    static void assertEquals(Object expected, Object actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(Object expected, Object actual, String message2) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual(expected, actual, message2);
        }
    }

    static void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertionUtils.failNotEqual(expected, actual, messageSupplier);
        }
    }
}

