/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.internal.management.ManagementFactory;
import org.junit.internal.management.ThreadMXBean;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailOnTimeout
extends Statement {
    private final Statement originalStatement;
    private final TimeUnit timeUnit;
    private final long timeout;
    private final boolean lookForStuckThread;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public FailOnTimeout(Statement statement2, long timeoutMillis) {
        this(FailOnTimeout.builder().withTimeout(timeoutMillis, TimeUnit.MILLISECONDS), statement2);
    }

    private FailOnTimeout(Builder builder2, Statement statement2) {
        this.originalStatement = statement2;
        this.timeout = builder2.timeout;
        this.timeUnit = builder2.unit;
        this.lookForStuckThread = builder2.lookForStuckThread;
    }

    @Override
    public void evaluate() throws Throwable {
        CallableStatement callable = new CallableStatement();
        FutureTask<Throwable> task2 = new FutureTask<Throwable>(callable);
        ThreadGroup threadGroup = this.threadGroupForNewThread();
        Thread thread2 = new Thread(threadGroup, task2, "Time-limited test");
        thread2.setDaemon(true);
        thread2.start();
        callable.awaitStarted();
        Throwable throwable = this.getResult(task2, thread2);
        if (throwable != null) {
            throw throwable;
        }
    }

    private ThreadGroup threadGroupForNewThread() {
        if (!this.lookForStuckThread) {
            return null;
        }
        ThreadGroup threadGroup = new ThreadGroup("FailOnTimeoutGroup");
        if (!threadGroup.isDaemon()) {
            try {
                threadGroup.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return threadGroup;
    }

    private Throwable getResult(FutureTask<Throwable> task2, Thread thread2) {
        try {
            if (this.timeout > 0L) {
                return task2.get(this.timeout, this.timeUnit);
            }
            return task2.get();
        }
        catch (InterruptedException e) {
            return e;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
        catch (TimeoutException e) {
            return this.createTimeoutException(thread2);
        }
    }

    private Exception createTimeoutException(Thread thread2) {
        StackTraceElement[] stackTrace2 = thread2.getStackTrace();
        Thread stuckThread = this.lookForStuckThread ? this.getStuckThread(thread2) : null;
        TestTimedOutException currThreadException = new TestTimedOutException(this.timeout, this.timeUnit);
        if (stackTrace2 != null) {
            currThreadException.setStackTrace(stackTrace2);
            thread2.interrupt();
        }
        if (stuckThread != null) {
            Exception stuckThreadException = new Exception("Appears to be stuck in thread " + stuckThread.getName());
            stuckThreadException.setStackTrace(this.getStackTrace(stuckThread));
            return new MultipleFailureException(Arrays.asList(currThreadException, stuckThreadException));
        }
        return currThreadException;
    }

    private StackTraceElement[] getStackTrace(Thread thread2) {
        try {
            return thread2.getStackTrace();
        }
        catch (SecurityException e) {
            return new StackTraceElement[0];
        }
    }

    private Thread getStuckThread(Thread mainThread) {
        List<Thread> threadsInGroup = this.getThreadsInGroup(mainThread.getThreadGroup());
        if (threadsInGroup.isEmpty()) {
            return null;
        }
        Thread stuckThread = null;
        long maxCpuTime = 0L;
        for (Thread thread2 : threadsInGroup) {
            if (thread2.getState() != Thread.State.RUNNABLE) continue;
            long threadCpuTime = this.cpuTime(thread2);
            if (stuckThread != null && threadCpuTime <= maxCpuTime) continue;
            stuckThread = thread2;
            maxCpuTime = threadCpuTime;
        }
        return stuckThread == mainThread ? null : stuckThread;
    }

    private List<Thread> getThreadsInGroup(ThreadGroup group) {
        int activeThreadCount = group.activeCount();
        int threadArraySize = Math.max(activeThreadCount * 2, 100);
        for (int loopCount = 0; loopCount < 5; ++loopCount) {
            Thread[] threads2 = new Thread[threadArraySize];
            int enumCount = group.enumerate(threads2);
            if (enumCount < threadArraySize) {
                return Arrays.asList(threads2).subList(0, enumCount);
            }
            threadArraySize += 100;
        }
        return Collections.emptyList();
    }

    private long cpuTime(Thread thr) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean.isThreadCpuTimeSupported()) {
            try {
                return mxBean.getThreadCpuTime(thr.getId());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallableStatement
    implements Callable<Throwable> {
        private final CountDownLatch startLatch = new CountDownLatch(1);

        private CallableStatement() {
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.startLatch.countDown();
                FailOnTimeout.this.originalStatement.evaluate();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                return e;
            }
            return null;
        }

        public void awaitStarted() throws InterruptedException {
            this.startLatch.await();
        }
    }

    public static class Builder {
        private boolean lookForStuckThread = false;
        private long timeout = 0L;
        private TimeUnit unit = TimeUnit.SECONDS;

        private Builder() {
        }

        public Builder withTimeout(long timeout2, TimeUnit unit) {
            if (timeout2 < 0L) {
                throw new IllegalArgumentException("timeout must be non-negative");
            }
            if (unit == null) {
                throw new NullPointerException("TimeUnit cannot be null");
            }
            this.timeout = timeout2;
            this.unit = unit;
            return this;
        }

        public Builder withLookingForStuckThread(boolean enable) {
            this.lookForStuckThread = enable;
            return this;
        }

        public FailOnTimeout build(Statement statement2) {
            if (statement2 == null) {
                throw new NullPointerException("statement cannot be null");
            }
            return new FailOnTimeout(this, statement2);
        }
    }
}

