/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JUnit4ClassRunner
extends Runner
implements Filterable,
Sortable {
    private final List<Method> testMethods;
    private TestClass testClass;

    public JUnit4ClassRunner(Class<?> klass) throws InitializationError {
        this.testClass = new TestClass(klass);
        this.testMethods = this.getTestMethods();
        this.validate();
    }

    protected List<Method> getTestMethods() {
        return this.testClass.getTestMethods();
    }

    protected void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.testClass);
        methodValidator.validateMethodsForDefaultRunner();
        methodValidator.assertValid();
    }

    @Override
    public void run(final RunNotifier notifier) {
        new ClassRoadie(notifier, this.testClass, this.getDescription(), new Runnable(){

            public void run() {
                JUnit4ClassRunner.this.runMethods(notifier);
            }
        }).runProtected();
    }

    protected void runMethods(RunNotifier notifier) {
        for (Method method2 : this.testMethods) {
            this.invokeTestMethod(method2, notifier);
        }
    }

    @Override
    public Description getDescription() {
        Description spec = Description.createSuiteDescription(this.getName(), this.classAnnotations());
        List<Method> testMethods = this.testMethods;
        for (Method method2 : testMethods) {
            spec.addChild(this.methodDescription(method2));
        }
        return spec;
    }

    protected Annotation[] classAnnotations() {
        return this.testClass.getJavaClass().getAnnotations();
    }

    protected String getName() {
        return this.getTestClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getConstructor().newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method2, RunNotifier notifier) {
        Object test;
        Description description2 = this.methodDescription(method2);
        try {
            test = this.createTest();
        }
        catch (InvocationTargetException e) {
            this.testAborted(notifier, description2, e.getCause());
            return;
        }
        catch (Exception e) {
            this.testAborted(notifier, description2, e);
            return;
        }
        TestMethod testMethod = this.wrapMethod(method2);
        new MethodRoadie(test, testMethod, notifier, description2).run();
    }

    private void testAborted(RunNotifier notifier, Description description2, Throwable e) {
        notifier.fireTestStarted(description2);
        notifier.fireTestFailure(new Failure(description2, e));
        notifier.fireTestFinished(description2);
    }

    protected TestMethod wrapMethod(Method method2) {
        return new TestMethod(method2, this.testClass);
    }

    protected String testName(Method method2) {
        return method2.getName();
    }

    protected Description methodDescription(Method method2) {
        return Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(method2), this.testAnnotations(method2));
    }

    protected Annotation[] testAnnotations(Method method2) {
        return method2.getAnnotations();
    }

    @Override
    public void filter(Filter filter2) throws NoTestsRemainException {
        Iterator<Method> iter = this.testMethods.iterator();
        while (iter.hasNext()) {
            Method method2 = iter.next();
            if (filter2.shouldRun(this.methodDescription(method2))) continue;
            iter.remove();
        }
        if (this.testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    @Override
    public void sort(final Sorter sorter) {
        Collections.sort(this.testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return sorter.compare(JUnit4ClassRunner.this.methodDescription(o1), JUnit4ClassRunner.this.methodDescription(o2));
            }
        });
    }

    protected TestClass getTestClass() {
        return this.testClass;
    }
}

