/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.BadResource;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResource;

public abstract class Resource
implements ResourceFactory,
Closeable {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;
    volatile Object _associate;

    public static void setDefaultUseCaches(boolean useCaches) {
        __defaultUseCaches = useCaches;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URI uri2) throws MalformedURLException {
        return Resource.newResource(uri2.toURL());
    }

    public static Resource newResource(URL url2) {
        return Resource.newResource(url2, __defaultUseCaches);
    }

    static Resource newResource(URL url2, boolean useCaches) {
        if (url2 == null) {
            return null;
        }
        String urlString = url2.toExternalForm();
        if (urlString.startsWith("file:")) {
            try {
                return new PathResource(url2);
            }
            catch (Exception e) {
                LOG.warn(e.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", e);
                return new BadResource(url2, e.toString());
            }
        }
        if (urlString.startsWith("jar:file:")) {
            return new JarFileResource(url2, useCaches);
        }
        if (urlString.startsWith("jar:")) {
            return new JarResource(url2, useCaches);
        }
        return new URLResource(url2, null, useCaches);
    }

    public static Resource newResource(String resource2) throws IOException {
        return Resource.newResource(resource2, __defaultUseCaches);
    }

    public static Resource newResource(String resource2, boolean useCaches) throws IOException {
        URL url2 = null;
        try {
            url2 = new URL(resource2);
        }
        catch (MalformedURLException e) {
            if (!(resource2.startsWith("ftp:") || resource2.startsWith("file:") || resource2.startsWith("jar:"))) {
                return new PathResource(Paths.get(resource2, new String[0]));
            }
            LOG.warn("Bad Resource: " + resource2, new Object[0]);
            throw e;
        }
        return Resource.newResource(url2, useCaches);
    }

    public static Resource newResource(File file2) {
        return new PathResource(file2.toPath());
    }

    public static Resource newResource(Path path) {
        return new PathResource(path);
    }

    public static Resource newSystemResource(String resource2) throws IOException {
        URL url2 = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                url2 = loader.getResource(resource2);
                if (url2 == null && resource2.startsWith("/")) {
                    url2 = loader.getResource(resource2.substring(1));
                }
            }
            catch (IllegalArgumentException e) {
                LOG.ignore(e);
                url2 = null;
            }
        }
        if (url2 == null && (loader = Resource.class.getClassLoader()) != null && (url2 = loader.getResource(resource2)) == null && resource2.startsWith("/")) {
            url2 = loader.getResource(resource2.substring(1));
        }
        if (url2 == null && (url2 = ClassLoader.getSystemResource(resource2)) == null && resource2.startsWith("/")) {
            url2 = ClassLoader.getSystemResource(resource2.substring(1));
        }
        if (url2 == null) {
            return null;
        }
        return Resource.newResource(url2);
    }

    public static Resource newClassPathResource(String resource2) {
        return Resource.newClassPathResource(resource2, true, false);
    }

    public static Resource newClassPathResource(String name, boolean useCaches, boolean checkParents) {
        URL url2 = Resource.class.getResource(name);
        if (url2 == null) {
            url2 = Loader.getResource(name);
        }
        if (url2 == null) {
            return null;
        }
        return Resource.newResource(url2, useCaches);
    }

    public static boolean isContainedIn(Resource r, Resource containingResource) throws MalformedURLException {
        return r.isContainedIn(containingResource);
    }

    protected void finalize() {
        this.close();
    }

    public abstract boolean isContainedIn(Resource var1) throws MalformedURLException;

    public boolean isSame(Resource resource2) {
        return this.equals(resource2);
    }

    public final void release() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    @Deprecated
    public abstract URL getURL();

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract ReadableByteChannel getReadableByteChannel() throws IOException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    @Override
    public Resource getResource(String path) {
        try {
            return this.addPath(path);
        }
        catch (Exception e) {
            LOG.debug(e);
            return null;
        }
    }

    @Deprecated
    public String encode(String uri2) {
        return null;
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object o) {
        this._associate = o;
    }

    public boolean isAlias() {
        return this.getAlias() != null;
    }

    public URI getAlias() {
        return null;
    }

    @Deprecated
    public String getListHTML(String base, boolean parent) throws IOException {
        return this.getListHTML(base, parent, null);
    }

    public String getListHTML(String base, boolean parent, String query) throws IOException {
        if ((base = URIUtil.canonicalPath(base)) == null || !this.isDirectory()) {
            return null;
        }
        String[] rawListing = this.list();
        if (rawListing == null) {
            return null;
        }
        boolean sortOrderAscending = true;
        String sortColumn = "N";
        if (query != null) {
            MultiMap<String> params = new MultiMap<String>();
            UrlEncoded.decodeUtf8To(query, 0, query.length(), params);
            String paramO = params.getString("O");
            String paramC = params.getString("C");
            if (StringUtil.isNotBlank(paramO)) {
                if (paramO.equals("A")) {
                    sortOrderAscending = true;
                } else if (paramO.equals("D")) {
                    sortOrderAscending = false;
                }
            }
            if (StringUtil.isNotBlank(paramC) && (paramC.equals("N") || paramC.equals("M") || paramC.equals("S"))) {
                sortColumn = paramC;
            }
        }
        ArrayList<Resource> items2 = new ArrayList<Resource>();
        for (String l : rawListing) {
            Resource item = this.addPath(l);
            items2.add(item);
        }
        if (sortColumn.equals("M")) {
            Collections.sort(items2, ResourceCollators.byLastModified(sortOrderAscending));
        } else if (sortColumn.equals("S")) {
            Collections.sort(items2, ResourceCollators.bySize(sortOrderAscending));
        } else {
            Collections.sort(items2, ResourceCollators.byName(sortOrderAscending));
        }
        String decodedBase = URIUtil.decodePath(base);
        String title = "Directory: " + Resource.deTag(decodedBase);
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<!DOCTYPE html>\n");
        buf.append("<html lang=\"en\">\n");
        buf.append("<head>\n");
        buf.append("<meta charset=\"utf-8\">\n");
        buf.append("<link href=\"jetty-dir.css\" rel=\"stylesheet\" />\n");
        buf.append("<title>");
        buf.append(title);
        buf.append("</title>\n");
        buf.append("</head>\n");
        buf.append("<body>\n");
        buf.append("<h1 class=\"title\">").append(title).append("</h1>\n");
        String ARROW_DOWN = "&nbsp; &#8681;";
        String ARROW_UP = "&nbsp; &#8679;";
        buf.append("<table class=\"listing\">\n");
        buf.append("<thead>\n");
        String arrow = "";
        String order = "A";
        if (sortColumn.equals("N")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<tr><th class=\"name\"><a href=\"?C=N&O=").append(order).append("\">");
        buf.append("Name").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("M")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"lastmodified\"><a href=\"?C=M&O=").append(order).append("\">");
        buf.append("Last Modified").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("S")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"size\"><a href=\"?C=S&O=").append(order).append("\">");
        buf.append("Size").append(arrow);
        buf.append("</a></th></tr>\n");
        buf.append("</thead>\n");
        buf.append("<tbody>\n");
        String encodedBase = Resource.hrefEncodeURI(base);
        if (parent) {
            buf.append("<tr><td class=\"name\"><a href=\"");
            buf.append(URIUtil.addPaths(encodedBase, "../"));
            buf.append("\">Parent Directory</a></td>");
            buf.append("<td class=\"lastmodified\">-</td>");
            buf.append("<td>-</td>");
            buf.append("</tr>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        for (Resource item : items2) {
            String name = item.getFileName();
            if (StringUtil.isBlank(name)) continue;
            if (item.isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            buf.append("<tr><td class=\"name\"><a href=\"");
            String path = URIUtil.addEncodedPaths(encodedBase, URIUtil.encodePath(name));
            buf.append(path);
            buf.append("\">");
            buf.append(Resource.deTag(name));
            buf.append("&nbsp;");
            buf.append("</a></td>");
            buf.append("<td class=\"lastmodified\">");
            long lastModified = item.lastModified();
            if (lastModified > 0L) {
                buf.append(dfmt.format(new Date(item.lastModified())));
            }
            buf.append("&nbsp;</td>");
            buf.append("<td class=\"size\">");
            long length = item.length();
            if (length >= 0L) {
                buf.append(String.format("%,d bytes", item.length()));
            }
            buf.append("&nbsp;</td></tr>\n");
        }
        buf.append("</tbody>\n");
        buf.append("</table>\n");
        buf.append("</body></html>\n");
        return buf.toString();
    }

    private String getFileName() {
        try {
            File file2 = this.getFile();
            if (file2 != null) {
                return file2.getName();
            }
        }
        catch (Throwable file2) {
            // empty catch block
        }
        try {
            String rawName = this.getName();
            int idx = rawName.lastIndexOf(47);
            if (idx == rawName.length() - 1) {
                idx = rawName.lastIndexOf(47, idx - 1);
            }
            String encodedFileName = idx >= 0 ? rawName.substring(idx + 1) : rawName;
            return UrlEncoded.decodeString(encodedFileName, 0, encodedFileName.length(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i2;
        StringBuffer buf = null;
        block9: for (i2 = 0; i2 < raw.length(); ++i2) {
            c = raw.charAt(i2);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i2 = 0; i2 < raw.length(); ++i2) {
            c = raw.charAt(i2);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                    continue block10;
                }
            }
        }
        return buf.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.sanitizeXmlString(raw);
    }

    public void writeTo(OutputStream out2, long start2, long count2) throws IOException {
        try (InputStream in = this.getInputStream();){
            in.skip(start2);
            if (count2 < 0L) {
                IO.copy(in, out2);
            } else {
                IO.copy(in, out2, count2);
            }
        }
    }

    public void copyTo(File destination) throws IOException {
        if (destination.exists()) {
            throw new IllegalArgumentException(destination + " exists");
        }
        try (FileOutputStream out2 = new FileOutputStream(destination);){
            this.writeTo(out2, 0L, -1L);
        }
    }

    public String getWeakETag() {
        return this.getWeakETag("");
    }

    public String getWeakETag(String suffix) {
        StringBuilder b = new StringBuilder(32);
        b.append("W/\"");
        String name = this.getName();
        int length = name.length();
        long lhash = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            lhash = 31L * lhash + (long)name.charAt(i2);
        }
        Base64.Encoder encoder2 = Base64.getEncoder().withoutPadding();
        b.append(encoder2.encodeToString(Resource.longToBytes(this.lastModified() ^ lhash)));
        b.append(encoder2.encodeToString(Resource.longToBytes(this.length() ^ lhash)));
        b.append(suffix);
        b.append('\"');
        return b.toString();
    }

    private static byte[] longToBytes(long value) {
        byte[] result2 = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            result2[i2] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result2;
    }

    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> deep = new ArrayList<Resource>();
            String[] list = this.list();
            if (list != null) {
                for (String i2 : list) {
                    Resource r = this.addPath(i2);
                    if (r.isDirectory()) {
                        deep.addAll(r.getAllResources());
                        continue;
                    }
                    deep.add(r);
                }
            }
            return deep;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL toURL(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }
}

