/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicBiInteger
extends AtomicLong {
    public AtomicBiInteger() {
    }

    public AtomicBiInteger(long encoded2) {
        super(encoded2);
    }

    public AtomicBiInteger(int hi, int lo) {
        super(AtomicBiInteger.encode(hi, lo));
    }

    public int getHi() {
        return AtomicBiInteger.getHi(this.get());
    }

    public int getLo() {
        return AtomicBiInteger.getLo(this.get());
    }

    public int getAndSetHi(int hi) {
        long update;
        long encoded2;
        while (!this.compareAndSet(encoded2 = this.get(), update = AtomicBiInteger.encodeHi(encoded2, hi))) {
        }
        return AtomicBiInteger.getHi(encoded2);
    }

    public int getAndSetLo(int lo) {
        long update;
        long encoded2;
        while (!this.compareAndSet(encoded2 = this.get(), update = AtomicBiInteger.encodeLo(encoded2, lo))) {
        }
        return AtomicBiInteger.getLo(encoded2);
    }

    public void set(int hi, int lo) {
        this.set(AtomicBiInteger.encode(hi, lo));
    }

    public boolean compareAndSetHi(int expectHi, int hi) {
        long update;
        long encoded2;
        do {
            if (AtomicBiInteger.getHi(encoded2 = this.get()) == expectHi) continue;
            return false;
        } while (!this.compareAndSet(encoded2, update = AtomicBiInteger.encodeHi(encoded2, hi)));
        return true;
    }

    public boolean compareAndSetLo(int expectLo, int lo) {
        long update;
        long encoded2;
        do {
            if (AtomicBiInteger.getLo(encoded2 = this.get()) == expectLo) continue;
            return false;
        } while (!this.compareAndSet(encoded2, update = AtomicBiInteger.encodeLo(encoded2, lo)));
        return true;
    }

    public boolean compareAndSet(long encoded2, int hi, int lo) {
        long update = AtomicBiInteger.encode(hi, lo);
        return this.compareAndSet(encoded2, update);
    }

    public boolean compareAndSet(int expectHi, int hi, int expectLo, int lo) {
        long encoded2 = AtomicBiInteger.encode(expectHi, expectLo);
        long update = AtomicBiInteger.encode(hi, lo);
        return this.compareAndSet(encoded2, update);
    }

    public int addAndGetHi(int delta) {
        int hi;
        long update;
        long encoded2;
        while (!this.compareAndSet(encoded2 = this.get(), update = AtomicBiInteger.encodeHi(encoded2, hi = AtomicBiInteger.getHi(encoded2) + delta))) {
        }
        return hi;
    }

    public int addAndGetLo(int delta) {
        int lo;
        long update;
        long encoded2;
        while (!this.compareAndSet(encoded2 = this.get(), update = AtomicBiInteger.encodeLo(encoded2, lo = AtomicBiInteger.getLo(encoded2) + delta))) {
        }
        return lo;
    }

    public void add(int deltaHi, int deltaLo) {
        long update;
        long encoded2;
        while (!this.compareAndSet(encoded2 = this.get(), update = AtomicBiInteger.encode(AtomicBiInteger.getHi(encoded2) + deltaHi, AtomicBiInteger.getLo(encoded2) + deltaLo))) {
        }
    }

    public static int getHi(long encoded2) {
        return (int)(encoded2 >> 32 & 0xFFFFFFFFL);
    }

    public static int getLo(long encoded2) {
        return (int)(encoded2 & 0xFFFFFFFFL);
    }

    public static long encode(int hi, int lo) {
        long h = (long)hi & 0xFFFFFFFFL;
        long l = (long)lo & 0xFFFFFFFFL;
        return (h << 32) + l;
    }

    public static long encodeHi(long encoded2, int hi) {
        long h = (long)hi & 0xFFFFFFFFL;
        long l = encoded2 & 0xFFFFFFFFL;
        return (h << 32) + l;
    }

    public static long encodeLo(long encoded2, int lo) {
        long h = encoded2 >> 32 & 0xFFFFFFFFL;
        long l = (long)lo & 0xFFFFFFFFL;
        return (h << 32) + l;
    }
}

