/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.api;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public interface Session {
    public void newStream(HeadersFrame var1, Promise<Stream> var2, Stream.Listener var3);

    public int priority(PriorityFrame var1, Callback var2);

    public void settings(SettingsFrame var1, Callback var2);

    public void ping(PingFrame var1, Callback var2);

    public boolean close(int var1, String var2, Callback var3);

    public boolean isClosed();

    public Collection<Stream> getStreams();

    public Stream getStream(int var1);

    public static interface Listener {
        public Map<Integer, Integer> onPreface(Session var1);

        public Stream.Listener onNewStream(Stream var1, HeadersFrame var2);

        public void onSettings(Session var1, SettingsFrame var2);

        public void onPing(Session var1, PingFrame var2);

        public void onReset(Session var1, ResetFrame var2);

        default public void onGoAway(Session session2, GoAwayFrame frame) {
        }

        default public void onClose(Session session2, GoAwayFrame frame, Callback callback) {
            try {
                this.onClose(session2, frame);
                callback.succeeded();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }

        public void onClose(Session var1, GoAwayFrame var2);

        public boolean onIdleTimeout(Session var1);

        default public void onFailure(Session session2, Throwable failure, Callback callback) {
            try {
                this.onFailure(session2, failure);
                callback.succeeded();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }

        public void onFailure(Session var1, Throwable var2);

        public static class Adapter
        implements Listener {
            @Override
            public Map<Integer, Integer> onPreface(Session session2) {
                return null;
            }

            @Override
            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                return null;
            }

            @Override
            public void onSettings(Session session2, SettingsFrame frame) {
            }

            @Override
            public void onPing(Session session2, PingFrame frame) {
            }

            @Override
            public void onReset(Session session2, ResetFrame frame) {
            }

            @Override
            public void onClose(Session session2, GoAwayFrame frame) {
            }

            @Override
            public boolean onIdleTimeout(Session session2) {
                return true;
            }

            @Override
            public void onFailure(Session session2, Throwable failure) {
            }
        }
    }
}

