/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie<Boolean>();
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Violation> _violations = EnumSet.noneOf(Violation.class);
    private boolean _emptySegment;

    public static HttpURI createHttpURI(String scheme2, String host2, int port2, String path, String param, String query, String fragment) {
        if (port2 == 80 && HttpScheme.HTTP.is(scheme2)) {
            port2 = 0;
        }
        if (port2 == 443 && HttpScheme.HTTPS.is(scheme2)) {
            port2 = 0;
        }
        return new HttpURI(scheme2, host2, port2, path, param, query, fragment);
    }

    public HttpURI() {
    }

    public HttpURI(String scheme2, String host2, int port2, String path, String param, String query, String fragment) {
        this._scheme = scheme2;
        this._host = host2;
        this._port = port2;
        if (path != null) {
            this.parse(State.PATH, path, 0, path.length());
        }
        if (param != null) {
            this._param = param;
        }
        if (query != null) {
            this._query = query;
        }
        if (fragment != null) {
            this._fragment = fragment;
        }
    }

    public HttpURI(HttpURI uri2) {
        this._scheme = uri2._scheme;
        this._user = uri2._user;
        this._host = uri2._host;
        this._port = uri2._port;
        this._path = uri2._path;
        this._param = uri2._param;
        this._query = uri2._query;
        this._fragment = uri2._fragment;
        this._uri = uri2._uri;
        this._decodedPath = uri2._decodedPath;
        this._violations.addAll(uri2._violations);
        this._emptySegment = false;
    }

    public HttpURI(HttpURI schemeHostPort, HttpURI uri2) {
        this._scheme = schemeHostPort._scheme;
        this._user = schemeHostPort._user;
        this._host = schemeHostPort._host;
        this._port = schemeHostPort._port;
        this._path = uri2._path;
        this._param = uri2._param;
        this._query = uri2._query;
        this._fragment = uri2._fragment;
        this._uri = uri2._uri;
        this._decodedPath = uri2._decodedPath;
        this._violations.addAll(uri2._violations);
        this._emptySegment = false;
    }

    public HttpURI(String uri2) {
        this._port = -1;
        this.parse(State.START, uri2, 0, uri2.length());
    }

    public HttpURI(URI uri2) {
        this._uri = null;
        this._scheme = uri2.getScheme();
        this._host = uri2.getHost();
        if (this._host == null && uri2.getRawSchemeSpecificPart().startsWith("//")) {
            this._host = "";
        }
        this._port = uri2.getPort();
        this._user = uri2.getUserInfo();
        String path = uri2.getRawPath();
        if (path != null) {
            this.parse(State.PATH, path, 0, path.length());
        }
        this._query = uri2.getRawQuery();
        this._fragment = uri2.getFragment();
    }

    public HttpURI(String scheme2, String host2, int port2, String pathQuery) {
        this._uri = null;
        this._scheme = scheme2;
        this._host = host2;
        this._port = port2;
        if (pathQuery != null) {
            this.parse(State.PATH, pathQuery, 0, pathQuery.length());
        }
    }

    public void clear() {
        this._uri = null;
        this._scheme = null;
        this._user = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._param = null;
        this._query = null;
        this._fragment = null;
        this._decodedPath = null;
        this._emptySegment = false;
        this._violations.clear();
    }

    public void parse(String uri2) {
        this.clear();
        this._uri = uri2;
        this.parse(State.START, uri2, 0, uri2.length());
    }

    public void parseRequestTarget(String method2, String uri2) {
        this.clear();
        this._uri = uri2;
        if (HttpMethod.CONNECT.is(method2)) {
            this.parse(State.HOST, uri2, 0, uri2.length());
        } else {
            this.parse(uri2.startsWith("/") ? State.PATH : State.START, uri2, 0, uri2.length());
        }
    }

    @Deprecated
    public void parseConnect(String uri2) {
        this.clear();
        this._uri = uri2;
        this._path = uri2;
    }

    public void parse(String uri2, int offset, int length) {
        this.clear();
        int end2 = offset + length;
        this._uri = uri2.substring(offset, end2);
        this.parse(State.START, uri2, offset, end2);
    }

    private void parse(State state, String uri2, int offset, int end2) {
        int mark = offset;
        int pathMark = 0;
        int segment = 0;
        boolean encodedPath2 = false;
        boolean encodedUtf16 = false;
        int encodedCharacters = 0;
        int encodedValue = 0;
        boolean dot = false;
        block75: for (int i2 = offset; i2 < end2; ++i2) {
            char c = uri2.charAt(i2);
            switch (state) {
                case START: {
                    switch (c) {
                        case '/': {
                            mark = i2;
                            state = State.HOST_OR_PATH;
                            continue block75;
                        }
                        case ';': {
                            this.checkSegment(uri2, segment, i2, true);
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(uri2, segment, i2, false);
                            this._path = "";
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(uri2, segment, i2, false);
                            this._path = "";
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block75;
                        }
                        case '%': {
                            encodedPath2 = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            pathMark = segment = i2;
                            mark = segment;
                            state = State.PATH;
                            continue block75;
                        }
                        case '.': {
                            dot = true;
                            pathMark = segment = i2;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    mark = i2;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block75;
                    }
                    pathMark = segment = i2;
                    state = State.PATH;
                    continue block75;
                }
                case SCHEME_OR_PATH: {
                    switch (c) {
                        case ':': {
                            this._scheme = uri2.substring(mark, i2);
                            state = State.START;
                            continue block75;
                        }
                        case '/': {
                            segment = i2 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this._path = uri2.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '%': {
                            encodedPath2 = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            state = State.PATH;
                            continue block75;
                        }
                        case '#': {
                            this._path = uri2.substring(mark, i2);
                            state = State.FRAGMENT;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case HOST_OR_PATH: {
                    switch (c) {
                        case '/': {
                            this._host = "";
                            mark = i2 + 1;
                            state = State.HOST;
                            continue block75;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i2;
                            pathMark = mark;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    pathMark = mark;
                    segment = mark + 1;
                    state = State.PATH;
                    continue block75;
                }
                case HOST: {
                    switch (c) {
                        case '/': {
                            this._host = uri2.substring(mark, i2);
                            pathMark = mark = i2;
                            segment = mark + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ':': {
                            if (i2 > mark) {
                                this._host = uri2.substring(mark, i2);
                            }
                            mark = i2 + 1;
                            state = State.PORT;
                            continue block75;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = uri2.substring(mark, i2);
                            mark = i2 + 1;
                            continue block75;
                        }
                        case '[': {
                            state = State.IPV6;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case IPV6: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri2);
                        }
                        case ']': {
                            c = uri2.charAt(++i2);
                            this._host = uri2.substring(mark, i2);
                            if (c == ':') {
                                mark = i2 + 1;
                                state = State.PORT;
                                continue block75;
                            }
                            pathMark = mark = i2;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PORT: {
                    if (c == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + uri2.substring(mark, i2);
                        mark = i2 + 1;
                        state = State.HOST;
                        continue block75;
                    }
                    if (c != '/') continue block75;
                    this._port = TypeUtil.parseInt(uri2, mark, i2 - mark, 10);
                    pathMark = mark = i2;
                    segment = i2 + 1;
                    state = State.PATH;
                    continue block75;
                }
                case PATH: {
                    if (encodedCharacters > 0) {
                        if (encodedCharacters == 2 && c == 'u' && !encodedUtf16) {
                            this._violations.add(Violation.UTF16);
                            encodedUtf16 = true;
                            encodedCharacters = 4;
                            continue block75;
                        }
                        encodedValue = (encodedValue << 4) + TypeUtil.convertHexDigit(c);
                        if (--encodedCharacters != 0) continue block75;
                        switch (encodedValue) {
                            case 0: {
                                throw new IllegalArgumentException("Illegal character in path");
                            }
                            case 47: {
                                this._violations.add(Violation.SEPARATOR);
                                continue block75;
                            }
                            case 37: {
                                this._violations.add(Violation.ENCODING);
                                continue block75;
                            }
                        }
                        continue block75;
                    }
                    switch (c) {
                        case ';': {
                            this.checkSegment(uri2, segment, i2, true);
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(uri2, segment, i2, false);
                            this._path = uri2.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(uri2, segment, i2, false);
                            this._path = uri2.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            if (i2 != 0) {
                                this.checkSegment(uri2, segment, i2, false);
                            }
                            segment = i2 + 1;
                            continue block75;
                        }
                        case '.': {
                            dot |= segment == i2;
                            continue block75;
                        }
                        case '%': {
                            encodedPath2 = true;
                            encodedUtf16 = false;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PARAM: {
                    switch (c) {
                        case '?': {
                            this._path = uri2.substring(pathMark, i2);
                            this._param = uri2.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this._path = uri2.substring(pathMark, i2);
                            this._param = uri2.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            encodedPath2 = true;
                            segment = i2 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            mark = i2 + 1;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case QUERY: {
                    if (c != '#') continue block75;
                    this._query = uri2.substring(mark, i2);
                    mark = i2 + 1;
                    state = State.FRAGMENT;
                    continue block75;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = uri2.substring(mark, end2);
                    i2 = end2;
                    continue block75;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
        }
        switch (state) {
            case START: {
                this._path = "";
                this.checkSegment(uri2, segment, end2, false);
                break;
            }
            case ASTERISK: {
                break;
            }
            case SCHEME_OR_PATH: 
            case HOST_OR_PATH: {
                this._path = uri2.substring(mark, end2);
                break;
            }
            case HOST: {
                if (end2 <= mark) break;
                this._host = uri2.substring(mark, end2);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri2);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(uri2, mark, end2 - mark, 10);
                break;
            }
            case PARAM: {
                this._path = uri2.substring(pathMark, end2);
                this._param = uri2.substring(mark, end2);
                break;
            }
            case PATH: {
                this.checkSegment(uri2, segment, end2, false);
                this._path = uri2.substring(pathMark, end2);
                break;
            }
            case QUERY: {
                this._query = uri2.substring(mark, end2);
                break;
            }
            case FRAGMENT: {
                this._fragment = uri2.substring(mark, end2);
                break;
            }
            default: {
                throw new IllegalStateException(state.toString());
            }
        }
        if (!encodedPath2 && !dot) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        } else if (this._path != null) {
            String decodedNonCanonical = URIUtil.decodePath(this._path);
            this._decodedPath = URIUtil.canonicalPath(decodedNonCanonical);
            if (this._decodedPath == null) {
                throw new IllegalArgumentException("Bad URI");
            }
        }
    }

    private void checkSegment(String uri2, int segment, int end2, boolean param) {
        Boolean ambiguous;
        if (this._emptySegment) {
            this._violations.add(Violation.EMPTY);
        }
        if (end2 == segment) {
            if (end2 >= uri2.length() || "#?".indexOf(uri2.charAt(end2)) >= 0) {
                return;
            }
            if (segment == 0) {
                this._violations.add(Violation.EMPTY);
                return;
            }
            if (!this._emptySegment) {
                this._emptySegment = true;
                return;
            }
        }
        if ((ambiguous = __ambiguousSegments.get(uri2, segment, end2 - segment)) != null) {
            if (Boolean.TRUE.equals(ambiguous)) {
                this._violations.add(Violation.SEGMENT);
            }
            if (param) {
                this._violations.add(Violation.PARAM);
            }
        }
    }

    public boolean hasAmbiguousSegment() {
        return this._violations.contains((Object)Violation.SEGMENT);
    }

    public boolean hasAmbiguousEmptySegment() {
        return this._violations.contains((Object)Violation.EMPTY);
    }

    public boolean hasAmbiguousSeparator() {
        return this._violations.contains((Object)Violation.SEPARATOR);
    }

    public boolean hasAmbiguousParameter() {
        return this._violations.contains((Object)Violation.PARAM);
    }

    public boolean hasAmbiguousEncoding() {
        return this._violations.contains((Object)Violation.ENCODING);
    }

    public boolean isAmbiguous() {
        return !this._violations.isEmpty() && (this._violations.size() != 1 || !this._violations.contains((Object)Violation.UTF16));
    }

    public boolean hasViolations() {
        return !this._violations.isEmpty();
    }

    boolean hasViolation(Violation violation) {
        return this._violations.contains((Object)violation);
    }

    public boolean hasUtf16Encoding() {
        return this._violations.contains((Object)Violation.UTF16);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        if (this._host != null && this._host.isEmpty()) {
            return null;
        }
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getDecodedPath() {
        return this._decodedPath;
    }

    public String getParam() {
        return this._param;
    }

    public void setParam(String param) {
        if (!Objects.equals(this._param, param)) {
            if (this._param != null && this._path.endsWith(";" + this._param)) {
                this._path = this._path.substring(0, this._path.length() - 1 - this._param.length());
            }
            this._param = param;
            if (this._param != null) {
                this._path = (this._path == null ? "" : this._path) + ";" + this._param;
            }
            this._uri = null;
        }
    }

    public String getQuery() {
        return this._query;
    }

    public boolean hasQuery() {
        return this._query != null && !this._query.isEmpty();
    }

    public String getFragment() {
        return this._fragment;
    }

    public void decodeQueryTo(MultiMap<String> parameters2) {
        if (this._query == null) {
            return;
        }
        UrlEncoded.decodeUtf8To(this._query, parameters2);
    }

    public void decodeQueryTo(MultiMap<String> parameters2, String encoding) throws UnsupportedEncodingException {
        this.decodeQueryTo(parameters2, Charset.forName(encoding));
    }

    public void decodeQueryTo(MultiMap<String> parameters2, Charset encoding) throws UnsupportedEncodingException {
        if (this._query == null) {
            return;
        }
        if (encoding == null || StandardCharsets.UTF_8.equals(encoding)) {
            UrlEncoded.decodeUtf8To(this._query, parameters2);
        } else {
            UrlEncoded.decodeTo(this._query, parameters2, encoding);
        }
    }

    public boolean isAbsolute() {
        return this._scheme != null && !this._scheme.isEmpty();
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder out2 = new StringBuilder();
            if (this._scheme != null) {
                out2.append(this._scheme).append(':');
            }
            if (this._host != null) {
                out2.append("//");
                if (this._user != null) {
                    out2.append(this._user).append('@');
                }
                out2.append(this._host);
            }
            if (this._port > 0) {
                out2.append(':').append(this._port);
            }
            if (this._path != null) {
                out2.append(this._path);
            }
            if (this._query != null) {
                out2.append('?').append(this._query);
            }
            if (this._fragment != null) {
                out2.append('#').append(this._fragment);
            }
            this._uri = out2.length() > 0 ? out2.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setScheme(String scheme2) {
        this._scheme = scheme2;
        this._uri = null;
    }

    public void setAuthority(String host2, int port2) {
        if (host2 != null && !this.isPathValidForAuthority(this._path)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._host = host2;
        this._port = port2;
        this._uri = null;
    }

    private boolean isPathValidForAuthority(String path) {
        if (path == null) {
            return true;
        }
        if (path.isEmpty() || "*".equals(path)) {
            return true;
        }
        return path.startsWith("/");
    }

    public void setPath(String path) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(path)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        if (path != null) {
            this.parse(State.PATH, path, 0, path.length());
        }
    }

    public void setPathQuery(String pathQuery) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(pathQuery)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        this._decodedPath = null;
        this._param = null;
        this._fragment = null;
        if (pathQuery != null) {
            this.parse(State.PATH, pathQuery, 0, pathQuery.length());
        }
    }

    private boolean hasAuthority() {
        return this._host != null;
    }

    public void setQuery(String query) {
        this._query = query;
        this._uri = null;
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString(this._query), this._fragment);
    }

    public String getPathQuery() {
        if (this._query == null) {
            return this._path;
        }
        return this._path + "?" + this._query;
    }

    public String getAuthority() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public String getUser() {
        return this._user;
    }

    static {
        __ambiguousSegments.put(".", Boolean.FALSE);
        __ambiguousSegments.put("%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e", Boolean.TRUE);
        __ambiguousSegments.put("..", Boolean.FALSE);
        __ambiguousSegments.put(".%2e", Boolean.TRUE);
        __ambiguousSegments.put(".%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%2e.", Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e.", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%u002e", Boolean.TRUE);
    }

    static enum Violation {
        SEGMENT("Ambiguous path segments"),
        SEPARATOR("Ambiguous path separator"),
        PARAM("Ambiguous path parameters"),
        ENCODING("Ambiguous double encoding"),
        EMPTY("Ambiguous empty segments"),
        UTF16("Non standard UTF-16 encoding");

        private final String _message;

        private Violation(String message2) {
            this._message = message2;
        }

        String getMessage() {
            return this._message;
        }
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

