/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.util.Locale;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;
    private final LongAdder outMessages = new LongAdder();

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSenderOverHTTP getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiverOverHTTP getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send(HttpExchange exchange) {
        this.outMessages.increment();
        this.sender.send(exchange);
    }

    @Override
    public void release() {
        this.connection.release();
    }

    @Override
    public Result exchangeTerminating(HttpExchange exchange, Result result2) {
        if (result2.isFailed()) {
            return result2;
        }
        HttpResponse response2 = exchange.getResponse();
        if (response2.getVersion() == HttpVersion.HTTP_1_1 && response2.getStatus() == 101) {
            String nextConnection = response2.getHeaders().get(HttpHeader.CONNECTION);
            if (nextConnection == null || !nextConnection.toLowerCase(Locale.US).contains("upgrade")) {
                return new Result(result2, new HttpResponseException("101 Switching Protocols without Connection: Upgrade not supported", response2));
            }
            HttpRequest request2 = exchange.getRequest();
            HttpConnectionUpgrader upgrader = (HttpConnectionUpgrader)request2.getConversation().getAttribute(HttpConnectionUpgrader.class.getName());
            if (upgrader != null) {
                try {
                    upgrader.upgrade(response2, this.getHttpConnection());
                }
                catch (Throwable x) {
                    return new Result(result2, x);
                }
            }
        }
        return result2;
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result2) {
        super.exchangeTerminated(exchange, result2);
        String method2 = exchange.getRequest().getMethod();
        Response response2 = result2.getResponse();
        HttpFields responseHeaders = response2.getHeaders();
        String closeReason = null;
        if (result2.isFailed()) {
            closeReason = "failure";
        } else if (this.receiver.isShutdown()) {
            closeReason = "server close";
        } else if (this.sender.isShutdown()) {
            closeReason = "client close";
        }
        if (closeReason == null) {
            if (response2.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
                boolean keepAlive = responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                boolean connect2 = HttpMethod.CONNECT.is(method2);
                if (!keepAlive && !connect2) {
                    closeReason = "http/1.0";
                }
            } else if (responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                closeReason = "http/1.1";
            }
        }
        if (closeReason != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", closeReason, this.connection);
            }
            this.connection.close();
        } else {
            int status2 = response2.getStatus();
            if (status2 == 101 || this.isTunnel(method2, status2)) {
                this.connection.remove();
            } else {
                this.release();
            }
        }
    }

    protected long getMessagesIn() {
        return this.receiver.getMessagesIn();
    }

    protected long getMessagesOut() {
        return this.outMessages.longValue();
    }

    boolean isTunnel(String method2, int status2) {
        return HttpMethod.CONNECT.is(method2) && HttpStatus.isSuccess(status2);
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

