/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response2) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response2);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response2) {
        try {
            listener.onBegin(response2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response2, HttpField field) {
        boolean result2 = true;
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeaderListener)) continue;
            result2 &= this.notifyHeader((Response.HeaderListener)listener, response2, field);
        }
        return result2;
    }

    private boolean notifyHeader(Response.HeaderListener listener, Response response2, HttpField field) {
        try {
            return listener.onHeader(response2, field);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response2) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response2);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response2) {
        try {
            listener.onHeaders(response2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyBeforeContent(Response response2, ObjLongConsumer<Object> demand, List<Response.DemandedContentListener> contentListeners) {
        for (Response.DemandedContentListener listener : contentListeners) {
            this.notifyBeforeContent(listener, response2, (long d) -> demand.accept(listener, d));
        }
    }

    private void notifyBeforeContent(Response.DemandedContentListener listener, Response response2, LongConsumer demand) {
        try {
            listener.onBeforeContent(response2, demand);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyContent(Response response2, ObjLongConsumer<Object> demand, ByteBuffer buffer, Callback callback, List<Response.DemandedContentListener> contentListeners) {
        int count2 = contentListeners.size();
        if (count2 == 0) {
            callback.succeeded();
            demand.accept(null, 1L);
        } else if (count2 == 1) {
            Response.DemandedContentListener listener = contentListeners.get(0);
            this.notifyContent(listener, response2, (long d) -> demand.accept(listener, d), buffer.slice(), callback);
        } else {
            callback = new CountingCallback(callback, count2);
            for (Response.DemandedContentListener listener : contentListeners) {
                this.notifyContent(listener, response2, (long d) -> demand.accept(listener, d), buffer.slice(), callback);
            }
        }
    }

    private void notifyContent(Response.DemandedContentListener listener, Response response2, LongConsumer demand, ByteBuffer buffer, Callback callback) {
        try {
            listener.onContent(response2, demand, buffer, callback);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response2) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response2);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response2) {
        try {
            listener.onSuccess(response2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response2, Throwable failure) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response2, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response2, Throwable failure) {
        try {
            listener.onFailure(response2, failure);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result2) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result2);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result2) {
        try {
            listener.onComplete(result2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response2) {
        this.forwardEvents(listeners, response2);
        this.notifySuccess(listeners, response2);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request2, Response response2) {
        this.forwardSuccess(listeners, response2);
        this.notifyComplete(listeners, new Result(request2, response2));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response2, Throwable failure) {
        this.forwardEvents(listeners, response2);
        this.notifyFailure(listeners, response2, failure);
    }

    private void forwardEvents(List<Response.ResponseListener> listeners, Response response2) {
        byte[] content2;
        this.notifyBegin(listeners, response2);
        Iterator<HttpField> iterator2 = response2.getHeaders().iterator();
        while (iterator2.hasNext()) {
            HttpField field = iterator2.next();
            if (this.notifyHeader(listeners, response2, field)) continue;
            iterator2.remove();
        }
        this.notifyHeaders(listeners, response2);
        if (response2 instanceof ContentResponse && (content2 = ((ContentResponse)response2).getContent()) != null && content2.length > 0) {
            List<Response.DemandedContentListener> contentListeners = listeners.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).collect(Collectors.toList());
            ObjLongConsumer<Object> demand = (context, value) -> {};
            this.notifyBeforeContent(response2, demand, contentListeners);
            this.notifyContent(response2, demand, ByteBuffer.wrap(content2), Callback.NOOP, contentListeners);
        }
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request2, Throwable requestFailure, Response response2, Throwable responseFailure) {
        this.forwardFailure(listeners, response2, responseFailure);
        this.notifyComplete(listeners, new Result(request2, requestFailure, response2, responseFailure));
    }
}

