/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    public RequestNotifier(HttpClient client2) {
        this.client = client2;
    }

    public void notifyQueued(Request request2) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.QueuedListener)) continue;
            this.notifyQueued((Request.QueuedListener)listener, request2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifyQueued(listener, request2);
        }
    }

    private void notifyQueued(Request.QueuedListener listener, Request request2) {
        try {
            listener.onQueued(request2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyBegin(Request request2) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.BeginListener)) continue;
            this.notifyBegin((Request.BeginListener)listener, request2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifyBegin(listener, request2);
        }
    }

    private void notifyBegin(Request.BeginListener listener, Request request2) {
        try {
            listener.onBegin(request2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyHeaders(Request request2) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.HeadersListener)) continue;
            this.notifyHeaders((Request.HeadersListener)listener, request2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifyHeaders(listener, request2);
        }
    }

    private void notifyHeaders(Request.HeadersListener listener, Request request2) {
        try {
            listener.onHeaders(request2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyCommit(Request request2) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.CommitListener)) continue;
            this.notifyCommit((Request.CommitListener)listener, request2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifyCommit(listener, request2);
        }
    }

    private void notifyCommit(Request.CommitListener listener, Request request2) {
        try {
            listener.onCommit(request2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyContent(Request request2, ByteBuffer content2) {
        if (!(content2 = content2.slice()).hasRemaining()) {
            return;
        }
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.ContentListener)) continue;
            content2.clear();
            this.notifyContent((Request.ContentListener)listener, request2, content2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            content2.clear();
            this.notifyContent(listener, request2, content2);
        }
    }

    private void notifyContent(Request.ContentListener listener, Request request2, ByteBuffer content2) {
        try {
            listener.onContent(request2, content2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifySuccess(Request request2) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.SuccessListener)) continue;
            this.notifySuccess((Request.SuccessListener)listener, request2);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifySuccess(listener, request2);
        }
    }

    private void notifySuccess(Request.SuccessListener listener, Request request2) {
        try {
            listener.onSuccess(request2);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyFailure(Request request2, Throwable failure) {
        List requestListeners = request2.getRequestListeners(null);
        for (int i2 = 0; i2 < requestListeners.size(); ++i2) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i2);
            if (!(listener instanceof Request.FailureListener)) continue;
            this.notifyFailure((Request.FailureListener)listener, request2, failure);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i3 = 0; i3 < listeners.size(); ++i3) {
            Request.Listener listener = listeners.get(i3);
            this.notifyFailure(listener, request2, failure);
        }
    }

    private void notifyFailure(Request.FailureListener listener, Request request2, Throwable failure) {
        try {
            listener.onFailure(request2, failure);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }
}

