/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 16384;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;
    private static final Pattern CHALLENGE_PATTERN = Pattern.compile("(?<schemeOnly>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)|(?:(?<scheme>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s+)?(?:(?<token68>[a-zA-Z0-9\\-._~+/]+=*)|(?<paramName>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s*=\\s*(?:(?<paramValue>.*)))");

    protected AuthenticationProtocolHandler(HttpClient client2, int maxContentLength) {
        this.client = client2;
        this.maxContentLength = maxContentLength;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    protected abstract String getAuthenticationAttribute();

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    protected List<Authentication.HeaderInfo> getHeaderInfo(String header) throws IllegalArgumentException {
        ArrayList<Authentication.HeaderInfo> headerInfos = new ArrayList<Authentication.HeaderInfo>();
        for (String value : new QuotedCSV(true, header)) {
            Matcher m = CHALLENGE_PATTERN.matcher(value);
            if (!m.matches()) continue;
            if (m.group("schemeOnly") != null) {
                headerInfos.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), m.group(1), new HashMap<String, String>()));
                continue;
            }
            if (m.group("scheme") != null) {
                headerInfos.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), m.group("scheme"), new HashMap<String, String>()));
            }
            if (headerInfos.isEmpty()) {
                throw new IllegalArgumentException("Parameters without auth-scheme");
            }
            Map<String, String> authParams = ((Authentication.HeaderInfo)headerInfos.get(headerInfos.size() - 1)).getParameters();
            if (m.group("paramName") != null) {
                String paramVal = QuotedCSV.unquote(m.group("paramValue"));
                authParams.put(m.group("paramName"), paramVal);
                continue;
            }
            if (m.group("token68") == null) continue;
            if (!authParams.isEmpty()) {
                throw new IllegalArgumentException("token68 after auth-params");
            }
            authParams.put("base64", m.group("token68"));
        }
        return headerInfos;
    }

    private class AfterAuthenticationListener
    extends Response.Listener.Adapter {
        private final Authentication.Result authenticationResult;

        private AfterAuthenticationListener(Authentication.Result authenticationResult) {
            this.authenticationResult = authenticationResult;
        }

        @Override
        public void onSuccess(Response response2) {
            int status2 = response2.getStatus();
            if (HttpStatus.isSuccess(status2) || HttpStatus.isRedirection(status2)) {
                AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(this.authenticationResult);
            }
        }
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result2) {
            HttpRequest request2 = (HttpRequest)result2.getRequest();
            HttpContentResponse response2 = new HttpContentResponse(result2.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result2.getResponseFailure() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", result2.getFailure());
                }
                this.forwardFailureComplete(request2, result2.getRequestFailure(), response2, result2.getResponseFailure());
                return;
            }
            String authenticationAttribute = AuthenticationProtocolHandler.this.getAuthenticationAttribute();
            HttpConversation conversation = request2.getConversation();
            if (conversation.getAttribute(authenticationAttribute) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", request2);
                }
                this.forwardSuccessComplete(request2, response2);
                return;
            }
            HttpHeader header = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> headerInfos = this.parseAuthenticateHeader(response2, header);
            if (headerInfos.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{header});
                }
                this.forwardFailureComplete(request2, result2.getRequestFailure(), response2, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + (Object)((Object)header) + " header", response2));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo headerInfo = null;
            URI authURI = this.resolveURI(request2, AuthenticationProtocolHandler.this.getAuthenticationURI(request2));
            if (authURI != null) {
                for (Authentication.HeaderInfo element : headerInfos) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(element.getType(), authURI, element.getRealm());
                    if (authentication == null) continue;
                    headerInfo = element;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", request2);
                }
                this.forwardSuccessComplete(request2, response2);
                return;
            }
            ContentProvider requestContent = request2.getContent();
            if (requestContent != null && !requestContent.isReproducible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content not reproducible for {}", request2);
                }
                this.forwardSuccessComplete(request2, response2);
                return;
            }
            try {
                Authentication.Result authnResult = authentication.authenticate(request2, response2, headerInfo, conversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", authnResult);
                }
                if (authnResult == null) {
                    this.forwardSuccessComplete(request2, response2);
                    return;
                }
                conversation.setAttribute(authenticationAttribute, true);
                URI requestURI = request2.getURI();
                String path = null;
                if (requestURI == null) {
                    requestURI = this.resolveURI(request2, null);
                    path = request2.getPath();
                }
                Request newRequest = AuthenticationProtocolHandler.this.client.copyRequest(request2, requestURI);
                long timeoutAt = request2.getTimeoutAt();
                if (timeoutAt < Long.MAX_VALUE) {
                    long newTimeout = timeoutAt - System.nanoTime();
                    if (newTimeout > 0L) {
                        newRequest.timeout(newTimeout, TimeUnit.NANOSECONDS);
                    } else {
                        TimeoutException failure = new TimeoutException("Total timeout " + request2.getConversation().getTimeout() + " ms elapsed");
                        this.forwardFailureComplete(request2, failure, response2, failure);
                        return;
                    }
                }
                if (path != null) {
                    newRequest.path(path);
                }
                authnResult.apply(newRequest);
                this.copyIfAbsent(request2, newRequest, HttpHeader.AUTHORIZATION);
                this.copyIfAbsent(request2, newRequest, HttpHeader.PROXY_AUTHORIZATION);
                AfterAuthenticationListener listener = new AfterAuthenticationListener(authnResult);
                Connection connection = (Connection)request2.getAttributes().get(Connection.class.getName());
                if (connection != null) {
                    connection.send(newRequest, listener);
                } else {
                    newRequest.send(listener);
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", x);
                }
                this.forwardFailureComplete(request2, null, response2, x);
            }
        }

        private URI resolveURI(HttpRequest request2, URI uri2) {
            if (uri2 != null) {
                return uri2;
            }
            String target = request2.getScheme() + "://" + request2.getHost();
            int port2 = request2.getPort();
            if (port2 > 0) {
                target = target + ":" + port2;
            }
            return URI.create(target);
        }

        private void copyIfAbsent(HttpRequest oldRequest, Request newRequest, HttpHeader header) {
            HttpField field = oldRequest.getHeaders().getField(header);
            if (field != null && !newRequest.getHeaders().contains(header)) {
                newRequest.getHeaders().put(field);
            }
        }

        private void forwardSuccessComplete(HttpRequest request2, Response response2) {
            HttpConversation conversation = request2.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(conversation.getResponseListeners(), request2, response2);
        }

        private void forwardFailureComplete(HttpRequest request2, Throwable requestFailure, Response response2, Throwable responseFailure) {
            HttpConversation conversation = request2.getConversation();
            conversation.updateResponseListeners(null);
            List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
            if (responseFailure == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccess(responseListeners, response2);
            } else {
                AuthenticationProtocolHandler.this.notifier.forwardFailure(responseListeners, response2, responseFailure);
            }
            AuthenticationProtocolHandler.this.notifier.notifyComplete(responseListeners, new Result(request2, requestFailure, response2, responseFailure));
        }

        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response2, HttpHeader header) {
            ArrayList<Authentication.HeaderInfo> result2 = new ArrayList<Authentication.HeaderInfo>();
            List<String> values2 = response2.getHeaders().getValuesList(header);
            for (String value : values2) {
                try {
                    result2.addAll(AuthenticationProtocolHandler.this.getHeaderInfo(value));
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to parse authentication header", e);
                }
            }
            return result2;
        }
    }
}

