/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import org.assertj.core.util.Preconditions;

public class MethodSupport {
    private static final String METHOD_HAS_NO_RETURN_VALUE = "Method '%s' in class %s.class has to return a value!";
    private static final String METHOD_NOT_FOUND = "Can't find method '%s' in class %s.class. Make sure public method exists and accepts no arguments!";

    public static Object methodResultFor(Object instance, String methodName) {
        Preconditions.checkNotNull(instance, "Object instance can not be null!");
        Preconditions.checkNotNullOrEmpty(methodName, "Method name can not be empty!");
        Method method2 = MethodSupport.findMethod(methodName, instance.getClass());
        return MethodSupport.invokeMethod(instance, method2);
    }

    private static Object invokeMethod(Object item, Method method2) {
        try {
            return method2.invoke(item, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Method findMethod(String methodName, Class<?> itemClass) {
        try {
            Method method2 = itemClass.getMethod(methodName, new Class[0]);
            MethodSupport.assertHasReturnType(itemClass, method2);
            return method2;
        }
        catch (SecurityException e) {
            throw MethodSupport.prepareMethodNotFoundException(methodName, itemClass, e);
        }
        catch (NoSuchMethodException e) {
            throw MethodSupport.prepareMethodNotFoundException(methodName, itemClass, e);
        }
    }

    private static IllegalArgumentException prepareMethodNotFoundException(String methodName, Class<?> itemClass, Exception cause) {
        String message2 = String.format(METHOD_NOT_FOUND, methodName, itemClass.getSimpleName());
        return new IllegalArgumentException(message2, cause);
    }

    private static void assertHasReturnType(Class<?> itemClass, Method method2) {
        Preconditions.checkArgument(!Void.TYPE.equals(method2.getReturnType()), METHOD_HAS_NO_RETURN_VALUE, method2.getName(), itemClass.getSimpleName());
    }
}

