/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import org.assertj.core.util.Preconditions;

public class Chunk<T> {
    private final int position;
    private List<T> lines;

    public Chunk(int position, List<T> lines) {
        this.position = position;
        this.lines = lines;
    }

    public void verify(List<T> target) throws IllegalStateException {
        Preconditions.checkState(this.last() <= target.size(), "Incorrect Chunk: the position of chunk > target size", new Object[0]);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Preconditions.checkState(target.get(this.position + i2).equals(this.lines.get(i2)), "Incorrect Chunk: the chunk content doesn't match the target", new Object[0]);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public List<T> getLines() {
        return this.lines;
    }

    public int size() {
        return this.lines.size();
    }

    public int last() {
        return this.getPosition() + this.size() - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.lines == null ? 0 : this.lines.hashCode());
        result2 = 31 * result2 + this.position;
        result2 = 31 * result2 + this.size();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size() + ", lines: " + this.lines + "]";
    }
}

