/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.matcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

@HashCodeAndEqualsPlugin.Enhance
public class CollectionOneToOneMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> matchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> matchers2) {
        this.matchers = matchers2;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.matchers.size()) {
            return false;
        }
        Iterator<ElementMatcher<T>> iterator2 = this.matchers.iterator();
        for (T value : target) {
            if (iterator2.hasNext() && iterator2.next().matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("containing(");
        boolean first2 = true;
        for (ElementMatcher<? super T> elementMatcher : this.matchers) {
            if (first2) {
                first2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementMatcher);
        }
        return stringBuilder.append(')').toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return ((Object)this.matchers).equals(((CollectionOneToOneMatcher)object).matchers);
    }

    public int hashCode() {
        return 17 * 31 + ((Object)this.matchers).hashCode();
    }
}

