/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.jar.asm.commons;

import org.assertj.core.internal.bytebuddy.jar.asm.AnnotationVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.Handle;
import org.assertj.core.internal.bytebuddy.jar.asm.Label;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.TypePath;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.AnnotationRemapper;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.Remapper;

public class MethodRemapper
extends MethodVisitor {
    protected final Remapper remapper;

    public MethodRemapper(MethodVisitor methodVisitor, Remapper remapper) {
        this(393216, methodVisitor, remapper);
    }

    protected MethodRemapper(int api, MethodVisitor methodVisitor, Remapper remapper) {
        super(api, methodVisitor);
        this.remapper = remapper;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(parameter, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public void visitFrame(int type2, int nLocal, Object[] local2, int nStack, Object[] stack2) {
        super.visitFrame(type2, nLocal, this.remapFrameTypes(nLocal, local2), nStack, this.remapFrameTypes(nStack, stack2));
    }

    private Object[] remapFrameTypes(int numTypes, Object[] frameTypes) {
        if (frameTypes == null) {
            return frameTypes;
        }
        Object[] remappedFrameTypes = null;
        for (int i2 = 0; i2 < numTypes; ++i2) {
            if (!(frameTypes[i2] instanceof String)) continue;
            if (remappedFrameTypes == null) {
                remappedFrameTypes = new Object[numTypes];
                System.arraycopy(frameTypes, 0, remappedFrameTypes, 0, numTypes);
            }
            remappedFrameTypes[i2] = this.remapper.mapType((String)frameTypes[i2]);
        }
        return remappedFrameTypes == null ? frameTypes : remappedFrameTypes;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name, descriptor2), this.remapper.mapDesc(descriptor2));
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor2) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner, name, descriptor2);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor2, opcode == 185);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner, name, descriptor2, isInterface);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor2, isInterface);
    }

    private void doVisitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name, descriptor2), this.remapper.mapMethodDesc(descriptor2), isInterface);
        }
    }

    public void visitInvokeDynamicInsn(String name, String descriptor2, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
        for (int i2 = 0; i2 < bootstrapMethodArguments.length; ++i2) {
            remappedBootstrapMethodArguments[i2] = this.remapper.mapValue(bootstrapMethodArguments[i2]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(name, descriptor2), this.remapper.mapMethodDesc(descriptor2), (Handle)this.remapper.mapValue(bootstrapMethodHandle), remappedBootstrapMethodArguments);
    }

    public void visitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type2));
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(this.remapper.mapValue(value));
    }

    public void visitMultiANewArrayInsn(String descriptor2, int numDimensions) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(descriptor2), numDimensions);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public void visitTryCatchBlock(Label start2, Label end2, Label handler2, String type2) {
        super.visitTryCatchBlock(start2, end2, handler2, type2 == null ? null : this.remapper.mapType(type2));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    public void visitLocalVariable(String name, String descriptor2, String signature2, Label start2, Label end2, int index) {
        super.visitLocalVariable(name, this.remapper.mapDesc(descriptor2), this.remapper.mapSignature(signature2, true), start2, end2, index);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end2, int[] index, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? annotationVisitor : new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }
}

