/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.jar.asm.commons;

import java.util.List;
import org.assertj.core.internal.bytebuddy.jar.asm.AnnotationVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.Attribute;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.FieldVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.ModuleVisitor;
import org.assertj.core.internal.bytebuddy.jar.asm.TypePath;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.AnnotationRemapper;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.FieldRemapper;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.MethodRemapper;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.ModuleHashesAttribute;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.ModuleRemapper;
import org.assertj.core.internal.bytebuddy.jar.asm.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        this(393216, classVisitor, remapper);
    }

    protected ClassRemapper(int api, ClassVisitor classVisitor, Remapper remapper) {
        super(api, classVisitor);
        this.remapper = remapper;
    }

    public void visit(int version2, int access, String name, String signature2, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version2, access, this.remapper.mapType(name), this.remapper.mapSignature(signature2, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
    }

    public ModuleVisitor visitModule(String name, int flags, String version2) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name), flags, version2);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List modules = moduleHashesAttribute.modules;
            for (int i2 = 0; i2 < modules.size(); ++i2) {
                modules.set(i2, this.remapper.mapModuleName((String)modules.get(i2)));
            }
        }
        super.visitAttribute(attribute);
    }

    public FieldVisitor visitField(int access, String name, String descriptor2, String signature2, Object value) {
        FieldVisitor fieldVisitor = super.visitField(access, this.remapper.mapFieldName(this.className, name, descriptor2), this.remapper.mapDesc(descriptor2), this.remapper.mapSignature(signature2, true), this.remapper.mapValue(value));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature2, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(descriptor2);
        MethodVisitor methodVisitor = super.visitMethod(access, this.remapper.mapMethodName(this.className, name, descriptor2), remappedDescriptor, this.remapper.mapSignature(signature2, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name), outerName == null ? null : this.remapper.mapType(outerName), innerName, access);
    }

    public void visitOuterClass(String owner, String name, String descriptor2) {
        super.visitOuterClass(this.remapper.mapType(owner), name == null ? null : this.remapper.mapMethodName(owner, name, descriptor2), descriptor2 == null ? null : this.remapper.mapMethodDesc(descriptor2));
    }

    public void visitNestHostExperimental(String nestHost) {
        super.visitNestHostExperimental(this.remapper.mapType(nestHost));
    }

    public void visitNestMemberExperimental(String nestMember) {
        super.visitNestMemberExperimental(this.remapper.mapType(nestMember));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }
}

