/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive;

import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.Assigner;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;

@HashCodeAndEqualsPlugin.Enhance
public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source2, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source2.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source2).widenTo(target);
        }
        if (source2.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source2).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source2).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source2, target, typing);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.referenceTypeAwareAssigner.equals(((PrimitiveTypeAwareAssigner)object).referenceTypeAwareAssigner);
    }

    public int hashCode() {
        return 17 * 31 + this.referenceTypeAwareAssigner.hashCode();
    }
}

