/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveFragment;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHaveParameter;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveScheme;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Uris {
    private static final String UTF_8 = "UTF-8";
    private static final String EQUAL = "=";
    private static final String AND = "&";
    private static final Uris INSTANCE = new Uris();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Uris instance() {
        return INSTANCE;
    }

    Uris() {
    }

    public void assertHasScheme(AssertionInfo info2, URI actual, String scheme2) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getScheme(), scheme2)) {
            throw this.failures.failure(info2, ShouldHaveScheme.shouldHaveScheme(actual, scheme2));
        }
    }

    public void assertHasPath(AssertionInfo info2, URI actual, String path) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getPath(), path)) {
            throw this.failures.failure(info2, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info2, URI actual, Integer expected) {
        Comparables.assertNotNull(info2, actual);
        if (actual.getPort() != expected.intValue()) {
            throw this.failures.failure(info2, ShouldHavePort.shouldHavePort(actual, (int)expected));
        }
    }

    public void assertHasHost(AssertionInfo info2, URI actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getHost(), expected)) {
            throw this.failures.failure(info2, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasAuthority(AssertionInfo info2, URI actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getAuthority(), expected)) {
            throw this.failures.failure(info2, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasFragment(AssertionInfo info2, URI actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getFragment(), expected)) {
            throw this.failures.failure(info2, ShouldHaveFragment.shouldHaveFragment(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info2, URI actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getQuery(), expected)) {
            throw this.failures.failure(info2, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info2, URI actual, String expected) {
        Comparables.assertNotNull(info2, actual);
        if (!Objects.areEqual(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info2, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }

    @VisibleForTesting
    public static Map<String, List<String>> getParameters(String query) {
        LinkedHashMap<String, List<String>> parameters2 = new LinkedHashMap<String, List<String>>();
        if (query != null && !query.isEmpty()) {
            for (String pair : query.split(AND)) {
                int equalIndex = pair.indexOf(EQUAL);
                String key2 = equalIndex == -1 ? pair : pair.substring(0, equalIndex);
                String value = equalIndex == -1 ? null : pair.substring(equalIndex + 1);
                try {
                    key2 = URLDecoder.decode(key2, UTF_8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (value != null) {
                    try {
                        value = URLDecoder.decode(value, UTF_8);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (!parameters2.containsKey(key2)) {
                    parameters2.put(key2, new ArrayList());
                }
                ((List)parameters2.get(key2)).add(value);
            }
        }
        return parameters2;
    }

    public void assertHasParameter(AssertionInfo info2, URI actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, name));
        }
    }

    public void assertHasParameter(AssertionInfo info2, URI actual, String expectedParameterName, String expectedParameterValue) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.containsKey(expectedParameterName)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue));
        }
        List<String> values2 = parameters2.get(expectedParameterName);
        if (!values2.contains(expectedParameterValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveParameter(actual, expectedParameterName, expectedParameterValue, values2));
        }
    }

    public void assertHasNoParameters(AssertionInfo info2, URI actual) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (!parameters2.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameters(actual, parameters2.keySet()));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URI actual, String name) {
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (parameters2.containsKey(name)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, parameters2.get(name)));
        }
    }

    public void assertHasNoParameter(AssertionInfo info2, URI actual, String name, String unwantedValue) {
        List<String> values2;
        Comparables.assertNotNull(info2, actual);
        Map<String, List<String>> parameters2 = Uris.getParameters(actual.getQuery());
        if (parameters2.containsKey(name) && (values2 = parameters2.get(name)).contains(unwantedValue)) {
            throw this.failures.failure(info2, ShouldHaveParameter.shouldHaveNoParameter(actual, name, unwantedValue, values2));
        }
    }
}

