/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Streams;

public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    protected StandardComparisonStrategy() {
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>((o1, o2) -> {
            if (this.areEqual(o1, o2)) {
                return 0;
            }
            return Objects.hashCodeFor(o1) < Objects.hashCodeFor(o2) ? -1 : 1;
        });
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        return Objects.areEqual(actual, other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return false;
        }
        return Streams.stream(iterable).anyMatch(object -> this.areEqual(object, value));
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if (!this.areEqual(iterator2.next(), value)) continue;
            iterator2.remove();
        }
    }

    @Override
    public void iterablesRemoveFirst(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if (!this.areEqual(iterator2.next(), value)) continue;
            iterator2.remove();
            return;
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        return string.contains(sequence);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        this.checkArgumentIsComparable(actual);
        return ((Comparable)Comparable.class.cast(actual)).compareTo(other) > 0;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        this.checkArgumentIsComparable(actual);
        return ((Comparable)Comparable.class.cast(actual)).compareTo(other) < 0;
    }

    private void checkArgumentIsComparable(Object actual) {
        Preconditions.checkArgument(actual instanceof Comparable, "argument '%s' should be Comparable but is not", actual);
    }

    @Override
    public boolean isStandard() {
        return true;
    }
}

