/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.exception.PathsException;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeCanonicalPath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeExecutable;
import org.assertj.core.error.ShouldBeNormalized;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRegularFile;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeSymbolicLink;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldEndWithPath;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.error.ShouldStartWithPath;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class Paths {
    private static final String FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH = "failed to resolve argument real path";
    private static final String FAILED_TO_RESOLVE_ACTUAL_REAL_PATH = "failed to resolve actual real path";
    @VisibleForTesting
    public static final String IOERROR_FORMAT = "I/O error attempting to process assertion for path: <%s>";
    private static final Paths INSTANCE = new Paths();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private NioFilesWrapper nioFilesWrapper;

    public static Paths instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Paths(NioFilesWrapper nioFilesWrapper) {
        this.nioFilesWrapper = nioFilesWrapper;
    }

    private Paths() {
        this(NioFilesWrapper.instance());
    }

    public void assertIsReadable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!this.nioFilesWrapper.isReadable(actual)) {
            throw this.failures.failure(info2, ShouldBeReadable.shouldBeReadable(actual));
        }
    }

    public void assertIsWritable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!this.nioFilesWrapper.isWritable(actual)) {
            throw this.failures.failure(info2, ShouldBeWritable.shouldBeWritable(actual));
        }
    }

    public void assertIsExecutable(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        this.assertExists(info2, actual);
        if (!this.nioFilesWrapper.isExecutable(actual)) {
            throw this.failures.failure(info2, ShouldBeExecutable.shouldBeExecutable(actual));
        }
    }

    public void assertExists(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!this.nioFilesWrapper.exists(actual, new LinkOption[0])) {
            throw this.failures.failure(info2, ShouldExist.shouldExist(actual));
        }
    }

    public void assertExistsNoFollowLinks(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!this.nioFilesWrapper.exists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info2, ShouldExist.shouldExistNoFollowLinks(actual));
        }
    }

    public void assertDoesNotExist(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!this.nioFilesWrapper.notExists(actual, LinkOption.NOFOLLOW_LINKS)) {
            throw this.failures.failure(info2, ShouldNotExist.shouldNotExist(actual));
        }
    }

    public void assertIsRegularFile(AssertionInfo info2, Path actual) {
        this.assertExists(info2, actual);
        if (!this.nioFilesWrapper.isRegularFile(actual)) {
            throw this.failures.failure(info2, ShouldBeRegularFile.shouldBeRegularFile(actual));
        }
    }

    public void assertIsDirectory(AssertionInfo info2, Path actual) {
        this.assertExists(info2, actual);
        if (!this.nioFilesWrapper.isDirectory(actual)) {
            throw this.failures.failure(info2, ShouldBeDirectory.shouldBeDirectory(actual));
        }
    }

    public void assertIsSymbolicLink(AssertionInfo info2, Path actual) {
        this.assertExistsNoFollowLinks(info2, actual);
        if (!this.nioFilesWrapper.isSymbolicLink(actual)) {
            throw this.failures.failure(info2, ShouldBeSymbolicLink.shouldBeSymbolicLink(actual));
        }
    }

    public void assertIsAbsolute(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!actual.isAbsolute()) {
            throw this.failures.failure(info2, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
        }
    }

    public void assertIsRelative(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (actual.isAbsolute()) {
            throw this.failures.failure(info2, ShouldBeRelativePath.shouldBeRelativePath(actual));
        }
    }

    public void assertIsNormalized(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (!actual.normalize().equals(actual)) {
            throw this.failures.failure(info2, ShouldBeNormalized.shouldBeNormalized(actual));
        }
    }

    public void assertIsCanonical(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        try {
            if (!actual.equals(actual.toRealPath(new LinkOption[0]))) {
                throw this.failures.failure(info2, ShouldBeCanonicalPath.shouldBeCanonicalPath(actual));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertHasParent(AssertionInfo info2, Path actual, Path expected) {
        Path canonicalExpected;
        Path canonicalActual;
        Paths.assertNotNull(info2, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        try {
            canonicalActual = actual.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
        try {
            canonicalExpected = expected.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH, e);
        }
        Path actualParent = canonicalActual.getParent();
        if (actualParent == null) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!actualParent.equals(canonicalExpected)) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, actualParent, expected));
        }
    }

    public void assertHasParentRaw(AssertionInfo info2, Path actual, Path expected) {
        Paths.assertNotNull(info2, actual);
        Paths.checkExpectedParentPathIsNotNull(expected);
        Path actualParent = actual.getParent();
        if (actualParent == null) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
        }
        if (!actualParent.equals(expected)) {
            throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, actualParent, expected));
        }
    }

    public void assertHasNoParent(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        try {
            Path canonicalActual = actual.toRealPath(new LinkOption[0]);
            if (canonicalActual.getParent() != null) {
                throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertHasNoParentRaw(AssertionInfo info2, Path actual) {
        Paths.assertNotNull(info2, actual);
        if (actual.getParent() != null) {
            throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
        }
    }

    public void assertStartsWith(AssertionInfo info2, Path actual, Path start2) {
        Path canonicalOther;
        Path canonicalActual;
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedStartPathIsNotNull(start2);
        try {
            canonicalActual = actual.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
        try {
            canonicalOther = start2.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ARGUMENT_REAL_PATH, e);
        }
        if (!canonicalActual.startsWith(canonicalOther)) {
            throw this.failures.failure(info2, ShouldStartWithPath.shouldStartWith(actual, start2));
        }
    }

    public void assertStartsWithRaw(AssertionInfo info2, Path actual, Path other) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedStartPathIsNotNull(other);
        if (!actual.startsWith(other)) {
            throw this.failures.failure(info2, ShouldStartWithPath.shouldStartWith(actual, other));
        }
    }

    public void assertEndsWith(AssertionInfo info2, Path actual, Path end2) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedEndPathIsNotNull(end2);
        try {
            Path canonicalActual = actual.toRealPath(new LinkOption[0]);
            if (!canonicalActual.endsWith(end2.normalize())) {
                throw this.failures.failure(info2, ShouldEndWithPath.shouldEndWith(actual, end2));
            }
        }
        catch (IOException e) {
            throw new PathsException(FAILED_TO_RESOLVE_ACTUAL_REAL_PATH, e);
        }
    }

    public void assertEndsWithRaw(AssertionInfo info2, Path actual, Path end2) {
        Paths.assertNotNull(info2, actual);
        Paths.assertExpectedEndPathIsNotNull(end2);
        if (!actual.endsWith(end2)) {
            throw this.failures.failure(info2, ShouldEndWithPath.shouldEndWith(actual, end2));
        }
    }

    public void assertHasFileName(AssertionInfo info2, Path actual, String fileName) {
        Paths.assertNotNull(info2, actual);
        Preconditions.checkNotNull(fileName, "expected fileName should not be null");
        if (!actual.getFileName().endsWith(fileName)) {
            throw this.failures.failure(info2, ShouldHaveName.shouldHaveName(actual, fileName));
        }
    }

    private static void assertNotNull(AssertionInfo info2, Path actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private static void checkExpectedParentPathIsNotNull(Path expected) {
        Preconditions.checkNotNull(expected, "expected parent path should not be null");
    }

    private static void assertExpectedStartPathIsNotNull(Path start2) {
        Preconditions.checkNotNull(start2, "the expected start path should not be null");
    }

    private static void assertExpectedEndPathIsNotNull(Path end2) {
        Preconditions.checkNotNull(end2, "the expected end path should not be null");
    }

    public void assertHasContent(AssertionInfo info2, Path actual, String expected, Charset charset) {
        Preconditions.checkNotNull(expected, "The text to compare to should not be null");
        this.assertIsReadable(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify text contents of path:<%s>", actual), e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info2, Path actual, byte[] expected) {
        Preconditions.checkNotNull(expected, "The binary content to compare to should not be null");
        this.assertIsReadable(info2, actual);
        try {
            BinaryDiffResult diffResult = this.binaryDiff.diff(actual, expected);
            if (diffResult.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, diffResult));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to verify binary contents of path:<%s>", actual), e);
        }
    }

    public void assertHasSameContentAs(AssertionInfo info2, Path actual, Charset actualCharset, Path expected, Charset expectedCharset) {
        Preconditions.checkNotNull(expected, "The given Path to compare actual content to should not be null");
        Preconditions.checkArgument(this.nioFilesWrapper.isReadable(expected), "The given Path <%s> to compare actual content to should be readable", expected);
        this.assertIsReadable(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to compare contents of paths:<%s> and:<%s>", actual, expected), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, MessageDigest digest, byte[] expected) {
        Preconditions.checkNotNull(digest, "The message digest algorithm should not be null");
        Preconditions.checkNotNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertIsRegularFile(info2, actual);
        this.assertIsReadable(info2, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual, new OpenOption[0]);){
            DigestDiff diff = Digests.digestDiff(actualStream, digest, expected);
            if (diff.digestsDiffer()) {
                throw this.failures.failure(info2, ShouldHaveDigest.shouldHaveDigest(actual, diff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, MessageDigest digest, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, String algorithm, byte[] expected) {
        Preconditions.checkNotNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info2, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, Path actual, String algorithm, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, algorithm, Digests.fromHex(expected));
    }
}

