/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainEntry;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainKey;
import org.assertj.core.error.ShouldContainKeys;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyKeys;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldContainValues;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainKey;
import org.assertj.core.error.ShouldNotContainKeys;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Maps {
    private static final Maps INSTANCE = new Maps();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();

    public static Maps instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Maps() {
    }

    public <K, V> void assertAllSatisfy(AssertionInfo info2, Map<K, V> actual, BiConsumer<? super K, ? super V> entryRequirements) {
        Preconditions.checkNotNull(entryRequirements, "The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.assertNotNull(info2, actual);
        actual.entrySet().stream().forEach(entry -> entryRequirements.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public void assertNullOrEmpty(AssertionInfo info2, Map<?, ?> actual) {
        if (actual != null && !actual.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info2, Map<?, ?> actual) {
        this.assertNotNull(info2, actual);
        if (!actual.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info2, Map<?, ?> actual) {
        this.assertNotNull(info2, actual);
        if (actual.isEmpty()) {
            throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public void assertHasSize(AssertionInfo info2, Map<?, ?> actual, int expectedSize) {
        this.assertNotNull(info2, actual);
        CommonValidations.checkSizes(actual, actual.size(), expectedSize, info2);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Map<?, ?> map2, Iterable<?> other) {
        this.assertNotNull(info2, map2);
        CommonValidations.hasSameSizeAsCheck(info2, map2, other, map2.size());
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Map<?, ?> map2, Object other) {
        this.assertNotNull(info2, map2);
        Arrays.assertIsArray(info2, other);
        CommonValidations.hasSameSizeAsCheck(info2, map2, other, map2.size());
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Map<?, ?> map2, Map<?, ?> other) {
        this.assertNotNull(info2, map2);
        CommonValidations.hasSameSizeAsCheck(info2, map2, other, map2.size());
    }

    public <K, V> void assertContains(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        this.assertNotNull(info2, actual);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        Maps.failIfEmptySinceActualIsNotEmpty(entries2);
        LinkedHashSet<Map.Entry<? extends K, ? extends V>> notFound = new LinkedHashSet<Map.Entry<? extends K, ? extends V>>();
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (this.containsEntry(actual, entry)) continue;
            notFound.add(entry);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info2, ShouldContain.shouldContain(actual, entries2, notFound));
    }

    public <K, V> void assertContainsAnyOf(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        this.assertNotNull(info2, actual);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        Maps.failIfEmptySinceActualIsNotEmpty(entries2);
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (!this.containsEntry(actual, entry)) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldContainAnyOf.shouldContainAnyOf(actual, entries2));
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info2, Map<K, V> actual, K key2, Condition<? super V> valueCondition) {
        this.assertContainsKeys(info2, actual, key2);
        this.conditions.assertIsNotNull(valueCondition);
        V value = actual.get(key2);
        if (!valueCondition.matches(value)) {
            throw this.failures.failure(info2, ElementsShouldBe.elementsShouldBe(actual, value, valueCondition));
        }
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info2, Map<K, V> actual, K key2, Consumer<? super V> valueRequirements) {
        this.assertContainsKeys(info2, actual, key2);
        Preconditions.checkNotNull(valueRequirements, "The Consumer<V> expressing the assertions requirements must not be null");
        V value = actual.get(key2);
        valueRequirements.accept(value);
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info2, Map<K, V> actual, Condition<? super Map.Entry<K, V>> entryCondition) {
        this.assertNotNull(info2, actual);
        this.conditions.assertIsNotNull(entryCondition);
        for (Map.Entry<K, V> entry : actual.entrySet()) {
            if (!entryCondition.matches(entry)) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldContainEntry.shouldContainEntry(actual, entryCondition));
    }

    public <K, V> void assertHasEntrySatisfyingConditions(AssertionInfo info2, Map<K, V> actual, Condition<? super K> keyCondition, Condition<? super V> valueCondition) {
        this.assertNotNull(info2, actual);
        this.conditions.assertIsNotNull(keyCondition, "The condition to evaluate for entries key should not be null", new Object[0]);
        this.conditions.assertIsNotNull(valueCondition, "The condition to evaluate for entries value should not be null", new Object[0]);
        for (Map.Entry<K, V> entry : actual.entrySet()) {
            if (!keyCondition.matches(entry.getKey()) || !valueCondition.matches(entry.getValue())) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldContainEntry.shouldContainEntry(actual, keyCondition, valueCondition));
    }

    public <K> void assertHasKeySatisfying(AssertionInfo info2, Map<K, ?> actual, Condition<? super K> keyCondition) {
        this.assertNotNull(info2, actual);
        this.conditions.assertIsNotNull(keyCondition);
        for (K key2 : actual.keySet()) {
            if (!keyCondition.matches(key2)) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldContainKey.shouldContainKey(actual, keyCondition));
    }

    public <V> void assertHasValueSatisfying(AssertionInfo info2, Map<?, V> actual, Condition<? super V> valueCondition) {
        this.assertNotNull(info2, actual);
        this.conditions.assertIsNotNull(valueCondition);
        for (V value : actual.values()) {
            if (!valueCondition.matches(value)) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldContainValue.shouldContainValue(actual, valueCondition));
    }

    public <K, V> void assertDoesNotContain(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNullOrEmpty(entries2);
        this.assertNotNull(info2, actual);
        LinkedHashSet<Map.Entry<? extends K, ? extends V>> found = new LinkedHashSet<Map.Entry<? extends K, ? extends V>>();
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (!this.containsEntry(actual, entry)) continue;
            found.add(entry);
        }
        if (found.isEmpty()) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotContain.shouldNotContain(actual, entries2, found));
    }

    public <K, V> void assertContainsKeys(AssertionInfo info2, Map<K, V> actual, K ... keys2) {
        this.assertNotNull(info2, actual);
        LinkedHashSet<K> notFound = new LinkedHashSet<K>();
        for (K key2 : keys2) {
            if (actual.containsKey(key2)) continue;
            notFound.add(key2);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info2, ShouldContainKeys.shouldContainKeys(actual, notFound));
    }

    public <K, V> void assertDoesNotContainKey(AssertionInfo info2, Map<K, V> actual, K key2) {
        this.assertNotNull(info2, actual);
        if (actual.containsKey(key2)) {
            throw this.failures.failure(info2, ShouldNotContainKey.shouldNotContainKey(actual, key2));
        }
    }

    public <K, V> void assertDoesNotContainKeys(AssertionInfo info2, Map<K, V> actual, K ... keys2) {
        this.assertNotNull(info2, actual);
        LinkedHashSet<K> found = new LinkedHashSet<K>();
        for (K key2 : keys2) {
            if (key2 == null || !actual.containsKey(key2)) continue;
            found.add(key2);
        }
        if (!found.isEmpty()) {
            throw this.failures.failure(info2, ShouldNotContainKeys.shouldNotContainKeys(actual, found));
        }
    }

    public <K, V> void assertContainsOnlyKeys(AssertionInfo info2, Map<K, V> actual, K ... keys2) {
        this.assertNotNull(info2, actual);
        Maps.failIfNull(keys2);
        if (actual.isEmpty() && keys2.length == 0) {
            return;
        }
        Maps.failIfEmpty(keys2);
        LinkedHashSet notFound = new LinkedHashSet();
        LinkedHashSet notExpected = new LinkedHashSet();
        this.compareActualMapAndExpectedKeys(actual, keys2, notExpected, notFound);
        if (!notFound.isEmpty() || !notExpected.isEmpty()) {
            throw this.failures.failure(info2, ShouldContainOnlyKeys.shouldContainOnlyKeys(actual, keys2, notFound, notExpected));
        }
    }

    public <K, V> void assertContainsValue(AssertionInfo info2, Map<K, V> actual, V value) {
        this.assertNotNull(info2, actual);
        if (!actual.containsValue(value)) {
            throw this.failures.failure(info2, ShouldContainValue.shouldContainValue(actual, value));
        }
    }

    public <K, V> void assertContainsValues(AssertionInfo info2, Map<K, V> actual, V ... values2) {
        this.assertNotNull(info2, actual);
        Preconditions.checkNotNull(values2, "The array of values to look for should not be null");
        if (actual.isEmpty() && values2.length == 0) {
            return;
        }
        LinkedHashSet<V> valuesNotFound = new LinkedHashSet<V>();
        for (V valueToLookFor : values2) {
            if (actual.containsValue(valueToLookFor)) continue;
            valuesNotFound.add(valueToLookFor);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.failures.failure(info2, ShouldContainValues.shouldContainValues(actual, valuesNotFound));
        }
    }

    public <K, V> void assertDoesNotContainValue(AssertionInfo info2, Map<K, V> actual, V value) {
        this.assertNotNull(info2, actual);
        if (actual.containsValue(value)) {
            throw this.failures.failure(info2, ShouldNotContainValue.shouldNotContainValue(actual, value));
        }
    }

    public <K, V> void assertContainsOnly(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V> ... entries2) {
        this.doCommonContainsCheck(info2, actual, entries2);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        Maps.failIfEmpty(entries2);
        LinkedHashSet<Map.Entry<K, V>> notFound = new LinkedHashSet<Map.Entry<K, V>>();
        LinkedHashSet<Map.Entry<K, V>> notExpected = new LinkedHashSet<Map.Entry<K, V>>();
        this.compareActualMapAndExpectedEntries(actual, entries2, notExpected, notFound);
        if (!notFound.isEmpty() || !notExpected.isEmpty()) {
            throw this.failures.failure(info2, ShouldContainOnly.shouldContainOnly(actual, entries2, notFound, notExpected));
        }
    }

    public <K, V> void assertContainsExactly(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V> ... entries2) {
        this.doCommonContainsCheck(info2, actual, entries2);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        Maps.failIfEmpty(entries2);
        this.assertHasSameSizeAs(info2, actual, entries2);
        LinkedHashSet<Map.Entry<K, V>> notFound = new LinkedHashSet<Map.Entry<K, V>>();
        LinkedHashSet<Map.Entry<K, V>> notExpected = new LinkedHashSet<Map.Entry<K, V>>();
        this.compareActualMapAndExpectedEntries(actual, entries2, notExpected, notFound);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int index = 0;
            for (K keyFromActual : actual.keySet()) {
                if (!org.assertj.core.util.Objects.areEqual(keyFromActual, entries2[index].getKey())) {
                    MapEntry<K, V> actualEntry = MapEntry.entry(keyFromActual, actual.get(keyFromActual));
                    throw this.failures.failure(info2, ShouldContainExactly.elementsDifferAtIndex(actualEntry, entries2[index], index));
                }
                ++index;
            }
            return;
        }
        throw this.failures.failure(info2, ShouldContainExactly.shouldContainExactly(actual, org.assertj.core.util.Arrays.asList(entries2), notFound, notExpected));
    }

    private <K, V> void compareActualMapAndExpectedKeys(Map<K, V> actual, K[] keys2, Set<K> notExpected, Set<K> notFound) {
        LinkedHashMap<K, V> actualEntries = new LinkedHashMap<K, V>(actual);
        for (K key2 : keys2) {
            if (actualEntries.containsKey(key2)) {
                actualEntries.remove(key2);
                continue;
            }
            notFound.add(key2);
        }
        notExpected.addAll(actualEntries.keySet());
    }

    private <K, V> void compareActualMapAndExpectedEntries(Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2, Set<Map.Entry<? extends K, ? extends V>> notExpected, Set<Map.Entry<? extends K, ? extends V>> notFound) {
        Map<K, V> expectedEntries = Maps.entriesToMap(entries2);
        LinkedHashMap<K, V> actualEntries = new LinkedHashMap<K, V>(actual);
        for (Map.Entry<Object, Object> entry : expectedEntries.entrySet()) {
            if (this.containsEntry(actualEntries, MapEntry.entry(entry.getKey(), entry.getValue()))) {
                actualEntries.remove(entry.getKey());
                continue;
            }
            notFound.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : actualEntries.entrySet()) {
            notExpected.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
    }

    private <K, V> void doCommonContainsCheck(AssertionInfo info2, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        this.assertNotNull(info2, actual);
        Maps.failIfNull(entries2);
    }

    private static <K, V> Map<K, V> entriesToMap(Map.Entry<? extends K, ? extends V>[] entries2) {
        LinkedHashMap<K, V> expectedEntries = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries2) {
            expectedEntries.put(entry.getKey(), entry.getValue());
        }
        return expectedEntries;
    }

    private static <K> void failIfEmpty(K[] keys2) {
        Preconditions.checkArgument(keys2.length > 0, "The array of keys to look for should not be empty", new Object[0]);
    }

    private static <K, V> void failIfEmpty(Map.Entry<? extends K, ? extends V>[] entries2) {
        Preconditions.checkArgument(entries2.length > 0, "The array of entries to look for should not be empty", new Object[0]);
    }

    private static <K, V> void failIfNullOrEmpty(Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        Maps.failIfEmpty(entries2);
    }

    private static <K> void failIfNull(K[] keys2) {
        Preconditions.checkNotNull(keys2, "The array of keys to look for should not be null");
    }

    private static <K, V> void failIfNull(Map.Entry<? extends K, ? extends V>[] entries2) {
        Preconditions.checkNotNull(entries2, "The array of entries to look for should not be null");
    }

    private <K, V> boolean containsEntry(Map<K, V> actual, Map.Entry<? extends K, ? extends V> entry) {
        Preconditions.checkNotNull(entry, "Entries to look for should not be null");
        return actual.containsKey(entry.getKey()) ? org.assertj.core.util.Objects.areEqual(actual.get(entry.getKey()), entry.getValue()) : false;
    }

    private void assertNotNull(AssertionInfo info2, Map<?, ?> actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private static <K, V> void failIfEmptySinceActualIsNotEmpty(Map.Entry<? extends K, ? extends V>[] values2) {
        if (values2.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }
}

