/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeFile;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveExtension;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class Files {
    private static final String UNABLE_TO_COMPARE_FILE_CONTENTS = "Unable to compare contents of files:<%s> and:<%s>";
    private static final Files INSTANCE = new Files();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    NioFilesWrapper nioFilesWrapper = NioFilesWrapper.instance();

    public static Files instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Files() {
    }

    public void assertSameContentAs(AssertionInfo info2, File actual, Charset actualCharset, File expected, Charset expectedCharset) {
        this.verifyIsFile(expected);
        this.assertIsFile(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (MalformedInputException e) {
            try {
                BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
                if (binaryDiffResult.hasNoDiff()) {
                    throw e;
                }
                throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), ioe);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info2, File actual, byte[] expected) {
        Preconditions.checkNotNull(expected, "The binary content to compare to should not be null");
        this.assertIsFile(info2, actual);
        try {
            BinaryDiffResult result2 = this.binaryDiff.diff(actual, expected);
            if (result2.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result2));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify binary contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    public void assertHasContent(AssertionInfo info2, File actual, String expected, Charset charset) {
        Preconditions.checkNotNull(expected, "The text to compare to should not be null");
        this.assertIsFile(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify text contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    private void verifyIsFile(File expected) {
        Preconditions.checkNotNull(expected, "The file to compare to should not be null");
        Preconditions.checkArgument(expected.isFile(), "Expected file:<'%s'> should be an existing file", expected);
    }

    public void assertIsFile(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.isFile()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeFile.shouldBeFile(actual));
    }

    public void assertIsDirectory(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.isDirectory()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeDirectory.shouldBeDirectory(actual));
    }

    public void assertIsAbsolute(AssertionInfo info2, File actual) {
        if (this.isAbsolutePath(info2, actual)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
    }

    public void assertIsRelative(AssertionInfo info2, File actual) {
        if (!this.isAbsolutePath(info2, actual)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeRelativePath.shouldBeRelativePath(actual));
    }

    private boolean isAbsolutePath(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        return actual.isAbsolute();
    }

    public void assertExists(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.exists()) {
            return;
        }
        throw this.failures.failure(info2, ShouldExist.shouldExist(actual));
    }

    public void assertDoesNotExist(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (!actual.exists()) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotExist.shouldNotExist(actual));
    }

    public void assertCanWrite(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.canWrite()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeWritable.shouldBeWritable(actual));
    }

    public void assertCanRead(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.canRead()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeReadable.shouldBeReadable(actual));
    }

    public void assertHasParent(AssertionInfo info2, File actual, File expected) {
        Preconditions.checkNotNull(expected, "The expected parent file should not be null.");
        Files.assertNotNull(info2, actual);
        try {
            if (actual.getParentFile() != null && org.assertj.core.util.Objects.areEqual(expected.getCanonicalFile(), actual.getParentFile().getCanonicalFile())) {
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to get canonical form of [%s] or [%s].", actual, expected), e);
        }
        throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
    }

    public void assertHasExtension(AssertionInfo info2, File actual, String expected) {
        Preconditions.checkNotNull(expected, "The expected extension should not be null.");
        this.assertIsFile(info2, actual);
        String actualExtension = this.getFileExtension(actual);
        if (expected.equals(actualExtension)) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveExtension.shouldHaveExtension(actual, actualExtension, expected));
    }

    private String getFileExtension(File file2) {
        String name = file2.getName();
        int dotAt = name.lastIndexOf(46);
        return dotAt == -1 ? null : name.substring(dotAt + 1);
    }

    public void assertHasName(AssertionInfo info2, File actual, String expected) {
        Files.assertNotNull(info2, actual);
        Preconditions.checkNotNull(expected, "The expected name should not be null.");
        if (expected.equals(actual.getName())) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveName.shouldHaveName(actual, expected));
    }

    private static void assertNotNull(AssertionInfo info2, File actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    public void assertHasNoParent(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.getParentFile() == null) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
    }

    public void assertHasDigest(AssertionInfo info2, File actual, MessageDigest digest, byte[] expected) {
        Preconditions.checkNotNull(digest, "The message digest algorithm should not be null");
        Preconditions.checkNotNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertExists(info2, actual);
        this.assertIsFile(info2, actual);
        this.assertCanRead(info2, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual.toPath(), new OpenOption[0]);){
            DigestDiff digestDiff = Digests.digestDiff(actualStream, digest, expected);
            if (digestDiff.digestsDiffer()) {
                throw this.failures.failure(info2, ShouldHaveDigest.shouldHaveDigest(actual, digestDiff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, File actual, MessageDigest digest, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info2, File actual, String algorithm, byte[] expected) {
        Preconditions.checkNotNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info2, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, File actual, String algorithm, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, algorithm, Digests.fromHex(expected));
    }
}

