/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class DoubleArrays {
    private static final DoubleArrays INSTANCE = new DoubleArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static DoubleArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    DoubleArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public DoubleArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    @VisibleForTesting
    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info2, double[] actual) {
        this.arrays.assertNullOrEmpty(info2, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info2, double[] actual) {
        this.arrays.assertEmpty(info2, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info2, double[] actual) {
        this.arrays.assertNotEmpty(info2, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info2, double[] actual, int expectedSize) {
        this.arrays.assertHasSize(info2, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, double[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, double[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContains(info2, this.failures, actual, values2);
    }

    public void assertContains(AssertionInfo info2, double[] actual, double value, Index index) {
        this.arrays.assertContains(info2, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info2, double[] actual, double value, Index index) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContainsOnly(info2, this.failures, actual, values2);
    }

    public void assertContainsOnlyOnce(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContainsOnlyOnce(info2, this.failures, actual, values2);
    }

    public void assertContainsExactly(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContainsExactly(info2, this.failures, actual, values2);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContainsExactlyInAnyOrder(info2, this.failures, actual, values2);
    }

    public void assertContainsSequence(AssertionInfo info2, double[] actual, double[] sequence) {
        this.arrays.assertContainsSequence(info2, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info2, double[] actual, double[] subsequence) {
        this.arrays.assertContainsSubsequence(info2, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, values2);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info2, double[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info2, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info2, double[] actual, double[] sequence) {
        this.arrays.assertStartsWith(info2, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info2, double[] actual, double[] sequence) {
        this.arrays.assertEndsWith(info2, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info2, double[] actual) {
        this.arrays.assertIsSorted(info2, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info2, double[] actual, Comparator<? super Double> comparator2) {
        Arrays.assertIsSortedAccordingToComparator(info2, this.failures, actual, comparator2);
    }

    public void assertContainsAnyOf(AssertionInfo info2, double[] actual, double[] values2) {
        this.arrays.assertContainsAnyOf(info2, this.failures, actual, values2);
    }
}

