/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeBetween;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeGreater;
import org.assertj.core.error.ShouldBeGreaterOrEqual;
import org.assertj.core.error.ShouldBeLess;
import org.assertj.core.error.ShouldBeLessOrEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Comparables {
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    @VisibleForTesting
    public Comparables() {
        this(StandardComparisonStrategy.instance());
    }

    public Comparables(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    @VisibleForTesting
    void setFailures(Failures failures) {
        this.failures = failures;
    }

    @VisibleForTesting
    void resetFailures() {
        this.failures = Failures.instance();
    }

    public int hashCode() {
        return java.util.Objects.hash(this.comparisonStrategy, this.failures);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comparables other = (Comparables)obj;
        if (this.comparisonStrategy == null ? other.comparisonStrategy != null : !this.comparisonStrategy.equals(other.comparisonStrategy)) {
            return false;
        }
        return !(this.failures == null ? other.failures != null : !this.failures.equals(other.failures));
    }

    public String toString() {
        return String.format("Comparables [comparisonStrategy=%s, failures=%s]", this.comparisonStrategy, this.failures);
    }

    public <T> void assertEqual(AssertionInfo info2, T actual, T expected) {
        Comparables.assertNotNull(info2, actual);
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy, info2.representation()));
    }

    protected <T> boolean areEqual(T actual, T expected) {
        return this.comparisonStrategy.areEqual(actual, expected);
    }

    public <T> void assertNotEqual(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertEqualByComparison(AssertionInfo info2, T actual, T expected) {
        Comparables.assertNotNull(info2, actual);
        if (actual.compareTo(expected) == 0) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(actual, expected, info2.representation()));
    }

    public <T extends Comparable<? super T>> void assertNotEqualByComparison(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (actual.compareTo(other) != 0) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    public <T extends Comparable<? super T>> void assertLessThan(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeLess.shouldBeLess(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertLessThanOrEqualTo(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (!this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeLessOrEqual.shouldBeLessOrEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertGreaterThan(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeGreater.shouldBeGreater(actual, other, this.comparisonStrategy));
    }

    private boolean isGreaterThan(Object actual, Object other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }

    public <T extends Comparable<? super T>> void assertGreaterThanOrEqualTo(AssertionInfo info2, T actual, T other) {
        Comparables.assertNotNull(info2, actual);
        if (!this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeGreaterOrEqual.shouldBeGreaterOrEqual(actual, other, this.comparisonStrategy));
    }

    private boolean isLessThan(Object actual, Object other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    protected static <T> void assertNotNull(AssertionInfo info2, T actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    public <T extends Comparable<? super T>> void assertIsBetween(AssertionInfo info2, T actual, T start2, T end2, boolean inclusiveStart, boolean inclusiveEnd) {
        boolean checkUpperBoundaryRange;
        boolean checkLowerBoundaryRange;
        Comparables.assertNotNull(info2, actual);
        Preconditions.checkNotNull(start2, "The start range to compare actual with should not be null");
        Preconditions.checkNotNull(end2, "The end range to compare actual with should not be null");
        this.checkBoundsValidity(start2, end2, inclusiveStart, inclusiveEnd);
        boolean bl = inclusiveStart ? !this.isGreaterThan(start2, actual) : (checkLowerBoundaryRange = this.isLessThan(start2, actual));
        boolean bl2 = inclusiveEnd ? !this.isGreaterThan(actual, end2) : (checkUpperBoundaryRange = this.isLessThan(actual, end2));
        if (checkLowerBoundaryRange && checkUpperBoundaryRange) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeBetween.shouldBeBetween(actual, start2, end2, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
    }

    protected <T extends Comparable<? super T>> void checkBoundsValidity(T start2, T end2, boolean inclusiveStart, boolean inclusiveEnd) {
        boolean inclusiveBoundsCheck = inclusiveEnd && inclusiveStart && !this.isGreaterThan(start2, end2);
        boolean strictBoundsCheck = !inclusiveEnd && !inclusiveStart && this.isLessThan(start2, end2);
        String operator = inclusiveEnd && inclusiveStart ? "less than" : "less than or equal to";
        String boundsCheckErrorMessage = String.format("The end value <%s> must not be %s the start value <%s>%s!", end2, operator, start2, this.comparisonStrategy.isStandard() ? "" : " (using " + this.comparisonStrategy + ")");
        Preconditions.checkArgument(inclusiveBoundsCheck || strictBoundsCheck, boundsCheckErrorMessage, new Object[0]);
    }
}

