/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldHaveLineCount;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ErrorMessages;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;

public final class CommonValidations {
    private static Failures failures = Failures.instance();

    private CommonValidations() {
    }

    static void checkIndexValueIsValid(Index index, int maximum) {
        Preconditions.checkNotNull(index, "Index should not be null");
        if (index.value <= maximum) {
            return;
        }
        String errorMessage2 = "Index should be between <0> and <%d> (inclusive) but was:%n <%d>";
        throw new IndexOutOfBoundsException(String.format(errorMessage2, maximum, index.value));
    }

    static void checkOffsetIsNotNull(Offset<?> offset) {
        Preconditions.checkNotNull(offset, "The given offset should not be null");
    }

    static void checkPercentageIsNotNull(Percentage percentage) {
        Preconditions.checkNotNull(percentage, "The given percentage should not be null");
    }

    static void checkNumberIsNotNull(Number number) {
        Preconditions.checkNotNull(number, "The given number should not be null");
    }

    static void checkIsNotEmpty(Object[] values2) {
        if (values2.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotEmpty(Iterable<?> iterable) {
        if (!iterable.iterator().hasNext()) {
            throw CommonErrors.iterableOfValuesToLookForIsEmpty();
        }
    }

    public static void checkIsNotNull(Object[] values2) {
        if (values2 == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNullAndNotEmpty(Object[] values2) {
        CommonValidations.checkIsNotNull(values2);
        CommonValidations.checkIsNotEmpty(values2);
    }

    static void checkIsNotNullAndNotEmpty(Iterable<?> iterable) {
        CommonValidations.checkIsNotNull(iterable);
        CommonValidations.checkIsNotEmpty(iterable);
    }

    public static void failIfEmptySinceActualIsNotEmpty(Object[] values2) {
        if (values2.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }

    public static void hasSameSizeAsCheck(AssertionInfo info2, Object actual, Object other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Array");
        CommonValidations.checkSameSizes(info2, actual, sizeOfActual, Array.getLength(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info2, Object actual, Iterable<?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Iterable");
        CommonValidations.checkSameSizes(info2, actual, sizeOfActual, IterableUtil.sizeOf(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info2, Object actual, Map<?, ?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Map");
        CommonValidations.checkSameSizes(info2, actual, sizeOfActual, other.size());
    }

    static void checkOtherIsNotNull(Object other, String otherType) {
        Preconditions.checkNotNull(other, "The " + otherType + " to compare actual size with should not be null");
    }

    static void checkSameSizes(AssertionInfo info2, Object actual, int sizeOfActual, int sizeOfOther) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info2, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkSizes(Object actual, int sizeOfActual, int sizeOfOther, AssertionInfo info2) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info2, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkLineCounts(Object actual, int lineCountOfActual, int lineCountOfOther, AssertionInfo info2) {
        if (lineCountOfActual != lineCountOfOther) {
            throw failures.failure(info2, ShouldHaveLineCount.shouldHaveLinesCount(actual, lineCountOfActual, lineCountOfOther));
        }
    }

    public static void checkTypeIsNotNull(Class<?> expectedType) {
        Preconditions.checkNotNull(expectedType, "The given type should not be null");
    }

    public static void checkIterableIsNotNull(AssertionInfo info2, Iterable<?> set2) {
        if (set2 == null) {
            throw CommonValidations.iterableToLookForIsNull();
        }
    }

    public static NullPointerException iterableToLookForIsNull() {
        return new NullPointerException("The iterable to look for should not be null");
    }

    public static void checkSequenceIsNotNull(Object sequence) {
        if (sequence == null) {
            throw new NullPointerException(ErrorMessages.nullSequence());
        }
    }

    public static void checkSubsequenceIsNotNull(Object subsequence) {
        if (subsequence == null) {
            throw new NullPointerException(ErrorMessages.nullSubsequence());
        }
    }
}

