/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Booleans {
    private static final Booleans INSTANCE = new Booleans();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Booleans instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Booleans() {
    }

    public void assertEqual(AssertionInfo info2, Boolean actual, boolean expected) {
        Booleans.assertNotNull(info2, actual);
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(actual, expected, info2.representation()));
    }

    public void assertNotEqual(AssertionInfo info2, Boolean actual, boolean other) {
        Booleans.assertNotNull(info2, actual);
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    private static void assertNotNull(AssertionInfo info2, Boolean actual) {
        Objects.instance().assertNotNull(info2, actual);
    }
}

