/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class BooleanArrays {
    private static final BooleanArrays INSTANCE = new BooleanArrays();
    private Arrays arrays;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static BooleanArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    BooleanArrays() {
        this.setArrays(Arrays.instance());
    }

    @VisibleForTesting
    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    public void assertNullOrEmpty(AssertionInfo info2, boolean[] actual) {
        this.arrays.assertNullOrEmpty(info2, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info2, boolean[] actual) {
        this.arrays.assertEmpty(info2, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info2, boolean[] actual) {
        this.arrays.assertNotEmpty(info2, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info2, boolean[] actual, int expectedSize) {
        this.arrays.assertHasSize(info2, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, boolean[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, boolean[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContains(info2, this.failures, actual, values2);
    }

    public void assertContains(AssertionInfo info2, boolean[] actual, boolean value, Index index) {
        this.arrays.assertContains(info2, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info2, boolean[] actual, boolean value, Index index) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContainsOnly(info2, this.failures, actual, values2);
    }

    public void assertContainsExactly(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContainsExactly(info2, this.failures, actual, values2);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContainsExactlyInAnyOrder(info2, this.failures, actual, values2);
    }

    public void assertContainsOnlyOnce(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContainsOnlyOnce(info2, this.failures, actual, values2);
    }

    public void assertContainsSequence(AssertionInfo info2, boolean[] actual, boolean[] sequence) {
        this.arrays.assertContainsSequence(info2, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info2, boolean[] actual, boolean[] subsequence) {
        this.arrays.assertContainsSubsequence(info2, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, values2);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info2, boolean[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info2, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info2, boolean[] actual, boolean[] sequence) {
        this.arrays.assertStartsWith(info2, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info2, boolean[] actual, boolean[] sequence) {
        this.arrays.assertEndsWith(info2, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info2, boolean[] actual) {
        this.arrays.assertIsSorted(info2, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info2, boolean[] actual, Comparator<? super Boolean> comparator2) {
        Arrays.assertIsSortedAccordingToComparator(info2, this.failures, actual, comparator2);
    }

    public void assertContainsAnyOf(AssertionInfo info2, boolean[] actual, boolean[] values2) {
        this.arrays.assertContainsAnyOf(info2, this.failures, actual, values2);
    }
}

