/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeAtMost;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ShouldBeAnArray;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSorted;
import org.assertj.core.error.ShouldBeSubsetOf;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainExactlyInAnyOrder;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyNulls;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldContainSubsequence;
import org.assertj.core.error.ShouldContainsOnlyOnce;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotContainSequence;
import org.assertj.core.error.ShouldNotContainSubsequence;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldOnlyHaveElementsOfTypes;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.IterableDiff;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Arrays {
    private static final Arrays INSTANCE = new Arrays();
    private final ComparisonStrategy comparisonStrategy;

    public static Arrays instance() {
        return INSTANCE;
    }

    public Arrays() {
        this(StandardComparisonStrategy.instance());
    }

    public Arrays(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (!(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy)) {
            return null;
        }
        return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public static void assertIsArray(AssertionInfo info2, Object array) {
        if (!org.assertj.core.util.Arrays.isArray(array)) {
            throw Failures.instance().failure(info2, ShouldBeAnArray.shouldBeAnArray(array));
        }
    }

    void assertNullOrEmpty(AssertionInfo info2, Failures failures, Object array) {
        if (array != null && !Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(array));
        }
    }

    void assertEmpty(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (!Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(array));
        }
    }

    void assertHasSize(AssertionInfo info2, Failures failures, Object array, int expectedSize) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = Arrays.sizeOf(array);
        if (sizeOfActual != expectedSize) {
            throw failures.failure(info2, ShouldHaveSize.shouldHaveSize(array, sizeOfActual, expectedSize));
        }
    }

    void assertHasSameSizeAs(AssertionInfo info2, Object array, Iterable<?> other) {
        Arrays.assertNotNull(info2, array);
        CommonValidations.hasSameSizeAsCheck(info2, array, other, Arrays.sizeOf(array));
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Object array, Object other) {
        Arrays.assertNotNull(info2, array);
        Arrays.assertIsArray(info2, array);
        Arrays.assertIsArray(info2, other);
        CommonValidations.hasSameSizeAsCheck(info2, array, other, Arrays.sizeOf(array));
    }

    @VisibleForTesting
    public void assertContains(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        int valueCount = Arrays.sizeOf(values2);
        for (int i2 = 0; i2 < valueCount; ++i2) {
            Object value = Array.get(values2, i2);
            if (this.arrayContains(actual, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContain.shouldContain(actual, values2, notFound, this.comparisonStrategy));
        }
    }

    void assertcontainsAll(AssertionInfo info2, Failures failures, Object array, Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableToLookForIsNull();
        }
        Arrays.assertNotNull(info2, array);
        Object[] values2 = Lists.newArrayList(iterable).toArray();
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values2) {
            if (this.arrayContains(array, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContain.shouldContain(array, values2, notFound, this.comparisonStrategy));
        }
    }

    void assertContains(AssertionInfo info2, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info2, array);
        this.assertNotEmpty(info2, failures, array);
        CommonValidations.checkIndexValueIsValid(index, Arrays.sizeOf(array) - 1);
        Object actualElement = Array.get(array, index.value);
        if (!this.areEqual(actualElement, value)) {
            throw failures.failure(info2, ShouldContainAtIndex.shouldContainAtIndex(array, value, index, Array.get(array, index.value), this.comparisonStrategy));
        }
    }

    void assertNotEmpty(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    void assertDoesNotContain(AssertionInfo info2, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info2, array);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        if (index.value >= Arrays.sizeOf(array)) {
            return;
        }
        if (this.areEqual(Array.get(array, index.value), value)) {
            throw failures.failure(info2, ShouldNotContainAtIndex.shouldNotContainAtIndex(array, value, index, this.comparisonStrategy));
        }
    }

    void assertContainsOnly(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values2);
        for (Object value : Arrays.asList(values2)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterableRemoves(notExpected, value);
            this.iterableRemoves(notFound, value);
        }
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContainOnly.shouldContainOnly(actual, values2, notFound, notExpected, this.comparisonStrategy));
        }
    }

    void assertContainsOnlyNulls(AssertionInfo info2, Failures failures, Object[] actual) {
        Arrays.assertNotNull(info2, actual);
        if (actual.length == 0) {
            throw failures.failure(info2, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual));
        }
        ArrayList<Object> nonNullElements = new ArrayList<Object>();
        for (Object element : actual) {
            if (element == null) continue;
            nonNullElements.add(element);
        }
        if (nonNullElements.size() > 0) {
            throw failures.failure(info2, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual, nonNullElements));
        }
    }

    void assertContainsExactly(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        Arrays.assertIsArray(info2, actual);
        Arrays.assertIsArray(info2, values2);
        List actualAsList = Arrays.asList(actual);
        IterableDiff diff = IterableDiff.diff(actualAsList, Arrays.asList(values2), this.comparisonStrategy);
        if (!diff.differencesFound()) {
            int arrayLength = Arrays.sizeOf(actual);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                Object expectedElement;
                Object actualElement = Array.get(actual, i2);
                if (this.areEqual(actualElement, expectedElement = Array.get(values2, i2))) continue;
                throw failures.failure(info2, ShouldContainExactly.elementsDifferAtIndex(actualElement, expectedElement, i2, this.comparisonStrategy));
            }
            return;
        }
        throw failures.failure(info2, ShouldContainExactly.shouldContainExactly(actual, Arrays.asList(values2), diff.missing, diff.unexpected, this.comparisonStrategy));
    }

    void assertContainsExactlyInAnyOrder(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values2);
        for (Object value : Arrays.asList(values2)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterablesRemoveFirst(notExpected, value);
            this.iterablesRemoveFirst(notFound, value);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw failures.failure(info2, ShouldContainExactlyInAnyOrder.shouldContainExactlyInAnyOrder(actual, values2, notFound, notExpected, this.comparisonStrategy));
    }

    void assertContainsOnlyOnce(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        Iterable<?> actualDuplicates = this.comparisonStrategy.duplicatesFrom(Arrays.asList(actual));
        LinkedHashSet notFound = new LinkedHashSet();
        LinkedHashSet notOnlyOnce = new LinkedHashSet();
        for (Object expectedElement : Arrays.asList(values2)) {
            if (!this.arrayContains(actual, expectedElement)) {
                notFound.add(expectedElement);
                continue;
            }
            if (!this.iterableContains(actualDuplicates, expectedElement)) continue;
            notOnlyOnce.add(expectedElement);
        }
        if (!notFound.isEmpty() || !notOnlyOnce.isEmpty()) {
            throw failures.failure(info2, ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, values2, notFound, notOnlyOnce, this.comparisonStrategy));
        }
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterablesRemoveFirst(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterablesRemoveFirst(actual, value);
    }

    private void iterableRemoves(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    void assertContainsSequence(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = Arrays.sizeOf(actual) - Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            return;
        }
        throw failures.failure(info2, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    void assertDoesNotContainSequence(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = Arrays.sizeOf(actual) - Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            throw failures.failure(info2, ShouldNotContainSequence.shouldNotContainSequence(actual, sequence, actualIndex, this.comparisonStrategy));
        }
    }

    private boolean containsSequenceAtGivenIndex(int actualStartIndex, Object actualArray, Object sequence) {
        int sequenceSize = Arrays.sizeOf(sequence);
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            if (this.areEqual(Array.get(sequence, i2), Array.get(actualArray, i2 + actualStartIndex))) continue;
            return false;
        }
        return true;
    }

    void assertContainsSubsequence(AssertionInfo info2, Failures failures, Object actual, Object subsequence) {
        if (Arrays.commonChecks(info2, actual, subsequence)) {
            return;
        }
        int sizeOfActual = Arrays.sizeOf(actual);
        int sizeOfSubsequence = Arrays.sizeOf(subsequence);
        int lastIndexWhereEndOfSubsequenceCanBeFound = sizeOfActual - sizeOfSubsequence;
        int subsequenceIndex = 0;
        for (int actualIndex = 0; actualIndex <= lastIndexWhereEndOfSubsequenceCanBeFound && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            ++subsequenceIndex;
            ++lastIndexWhereEndOfSubsequenceCanBeFound;
        }
        if (subsequenceIndex < sizeOfSubsequence) {
            throw failures.failure(info2, ShouldContainSubsequence.shouldContainSubsequence(actual, subsequence, this.comparisonStrategy));
        }
    }

    void assertHasOnlyElementsOfTypes(AssertionInfo info2, Failures failures, Object actual, Class<?>[] expectedTypes) {
        Arrays.checkIsNotNull(expectedTypes);
        Arrays.assertNotNull(info2, actual);
        ArrayList nonMatchingElements = Lists.newArrayList();
        for (Object value : Arrays.asList(actual)) {
            boolean matching = false;
            for (Class<?> expectedType : expectedTypes) {
                if (!expectedType.isInstance(value)) continue;
                matching = true;
            }
            if (matching) continue;
            nonMatchingElements.add(value);
        }
        if (!nonMatchingElements.isEmpty()) {
            throw failures.failure(info2, ShouldOnlyHaveElementsOfTypes.shouldOnlyHaveElementsOfTypes(actual, expectedTypes, nonMatchingElements));
        }
    }

    void assertDoesNotContainSubsequence(AssertionInfo info2, Failures failures, Object actual, Object subsequence) {
        if (Arrays.commonChecks(info2, actual, subsequence)) {
            return;
        }
        int sizeOfActual = Arrays.sizeOf(actual);
        int sizeOfSubsequence = Arrays.sizeOf(subsequence);
        int lastIndexWhereEndOfSubsequenceCanBeFound = sizeOfActual - sizeOfSubsequence;
        int subsequenceIndex = 0;
        int subsequenceStartIndex = 0;
        for (int actualIndex = 0; actualIndex <= lastIndexWhereEndOfSubsequenceCanBeFound && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            if (subsequenceIndex == 0) {
                subsequenceStartIndex = actualIndex;
            }
            ++subsequenceIndex;
            ++lastIndexWhereEndOfSubsequenceCanBeFound;
            if (subsequenceIndex != sizeOfSubsequence) continue;
            throw failures.failure(info2, ShouldNotContainSubsequence.shouldNotContainSubsequence(actual, subsequence, this.comparisonStrategy, subsequenceStartIndex));
        }
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    void assertDoesNotContain(AssertionInfo info2, Failures failures, Object array, Object values2) {
        Arrays.checkIsNotNullAndNotEmpty(values2);
        Arrays.assertNotNull(info2, array);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        int valuesSize = Arrays.sizeOf(values2);
        for (int i2 = 0; i2 < valuesSize; ++i2) {
            Object value = Array.get(values2, i2);
            if (!this.arrayContains(array, value)) continue;
            found.add(value);
        }
        if (!found.isEmpty()) {
            throw failures.failure(info2, ShouldNotContain.shouldNotContain(array, values2, found, this.comparisonStrategy));
        }
    }

    private boolean arrayContains(Object array, Object value) {
        return this.comparisonStrategy.arrayContains(array, value);
    }

    void assertDoesNotHaveDuplicates(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        ArrayWrapperList wrapped = ArrayWrapperList.wrap(array);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(wrapped);
        if (!IterableUtil.isNullOrEmpty(duplicates)) {
            throw failures.failure(info2, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(array, duplicates, this.comparisonStrategy));
        }
    }

    void assertStartsWith(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int sequenceSize = Arrays.sizeOf(sequence);
        int arraySize = Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotStartWithSequence(info2, failures, actual, sequence);
        }
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            if (this.areEqual(Array.get(sequence, i2), Array.get(actual, i2))) continue;
            throw this.arrayDoesNotStartWithSequence(info2, failures, actual, sequence);
        }
    }

    private static boolean commonChecks(AssertionInfo info2, Object actual, Object sequence) {
        Arrays.checkNulls(info2, actual, sequence);
        if (Arrays.isArrayEmpty(actual) && Arrays.isArrayEmpty(sequence)) {
            return true;
        }
        Arrays.failIfEmptySinceActualIsNotEmpty(sequence);
        return false;
    }

    private static void checkNulls(AssertionInfo info2, Object actual, Object sequence) {
        Arrays.checkIsNotNull(sequence);
        Arrays.assertNotNull(info2, actual);
    }

    private AssertionError arrayDoesNotStartWithSequence(AssertionInfo info2, Failures failures, Object array, Object sequence) {
        return failures.failure(info2, ShouldStartWith.shouldStartWith(array, sequence, this.comparisonStrategy));
    }

    void assertEndsWith(AssertionInfo info2, Failures failures, Object actual, Object first2, Object[] rest) {
        Object[] sequence = org.assertj.core.util.Arrays.prepend(first2, rest);
        this.assertEndsWith(info2, failures, actual, sequence);
    }

    void assertEndsWith(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        Arrays.checkNulls(info2, actual, sequence);
        int sequenceSize = Arrays.sizeOf(sequence);
        int arraySize = Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotEndWithSequence(info2, failures, actual, sequence);
        }
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            int sequenceIndex = sequenceSize - (i2 + 1);
            int arrayIndex = arraySize - (i2 + 1);
            if (this.areEqual(Array.get(sequence, sequenceIndex), Array.get(actual, arrayIndex))) continue;
            throw this.arrayDoesNotEndWithSequence(info2, failures, actual, sequence);
        }
    }

    public void assertIsSubsetOf(AssertionInfo info2, Failures failures, Object actual, Iterable<?> values2) {
        Arrays.assertNotNull(info2, actual);
        CommonValidations.checkIterableIsNotNull(info2, values2);
        ArrayList extra = Lists.newArrayList();
        int sizeOfActual = Arrays.sizeOf(actual);
        for (int i2 = 0; i2 < sizeOfActual; ++i2) {
            Object actualElement = Array.get(actual, i2);
            if (this.iterableContains(values2, actualElement)) continue;
            extra.add(actualElement);
        }
        if (extra.size() > 0) {
            throw failures.failure(info2, ShouldBeSubsetOf.shouldBeSubsetOf(actual, values2, extra, this.comparisonStrategy));
        }
    }

    void assertContainsNull(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (!this.arrayContains(array, null)) {
            throw failures.failure(info2, ShouldContainNull.shouldContainNull(array));
        }
    }

    void assertDoesNotContainNull(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (this.arrayContains(array, null)) {
            throw failures.failure(info2, ShouldNotContainNull.shouldNotContainNull(array));
        }
    }

    public <E> void assertAre(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info2, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info2, ElementsShouldBe.elementsShouldBe(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info2, ElementsShouldNotBe.elementsShouldNotBe(array, matchingElements, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info2, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info2, ElementsShouldHave.elementsShouldHave(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertHaveNot(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info2, ElementsShouldNotHave.elementsShouldNotHave(array, matchingElements, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info2, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(array, times, condition));
        }
    }

    public <E> void assertAreAtMost(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info2, ElementsShouldBeAtMost.elementsShouldBeAtMost(array, times, condition));
        }
    }

    public <E> void assertAreExactly(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info2, ElementsShouldBeExactly.elementsShouldBeExactly(array, times, condition));
        }
    }

    public <E> void assertHaveAtLeast(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info2, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(array, times, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info2, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(array, times, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info2, ElementsShouldHaveExactly.elementsShouldHaveExactly(array, times, condition));
        }
    }

    public void assertContainsAnyOf(AssertionInfo info2, Failures failures, Object actual, Object values2) {
        if (Arrays.commonChecks(info2, actual, values2)) {
            return;
        }
        Arrays.assertIsArray(info2, actual);
        Arrays.assertIsArray(info2, values2);
        List valuesToSearchFor = Arrays.asList(values2);
        for (Object element : Arrays.asList(actual)) {
            if (!this.iterableContains(valuesToSearchFor, element)) continue;
            return;
        }
        throw failures.failure(info2, ShouldContainAnyOf.shouldContainAnyOf(actual, values2, this.comparisonStrategy));
    }

    private <E> List<E> getElementsMatchingCondition(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info2, failures, conditions, array, condition, false);
    }

    private <E> List<E> getElementsNotMatchingCondition(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info2, failures, conditions, array, condition, true);
    }

    private <E> List<E> filterElements(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition, boolean negateCondition) throws AssertionError {
        Arrays.assertNotNull(info2, array);
        conditions.assertIsNotNull(condition);
        try {
            LinkedList<Object> filteredElements = new LinkedList<Object>();
            int arraySize = Arrays.sizeOf(array);
            for (int i2 = 0; i2 < arraySize; ++i2) {
                Object element = Array.get(array, i2);
                if (!(negateCondition ? !condition.matches(element) : condition.matches(element))) continue;
                filteredElements.add(element);
            }
            return filteredElements;
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    void assertIsSorted(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator2 = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            Arrays.assertIsSortedAccordingToComparator(info2, failures, array, comparator2);
            return;
        }
        if (Arrays.sizeOf(array) == 0) {
            return;
        }
        Arrays.assertThatArrayComponentTypeIsSortable(info2, failures, array);
        try {
            Comparable<Object>[] comparableArray = Arrays.arrayOfComparableItems(array);
            if (comparableArray.length <= 1) {
                return;
            }
            for (int i2 = 0; i2 < comparableArray.length - 1; ++i2) {
                if (comparableArray[i2].compareTo(comparableArray[i2 + 1]) <= 0) continue;
                throw failures.failure(info2, ShouldBeSorted.shouldBeSorted(i2, array));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    static <T> void assertIsSortedAccordingToComparator(AssertionInfo info2, Failures failures, Object array, Comparator<T> comparator2) {
        Arrays.assertNotNull(info2, array);
        Preconditions.checkNotNull(comparator2, "The given comparator should not be null");
        try {
            List<T> arrayAsList = Arrays.asList(array);
            if (arrayAsList.size() == 0) {
                return;
            }
            if (arrayAsList.size() == 1) {
                comparator2.compare(arrayAsList.get(0), arrayAsList.get(0));
                return;
            }
            for (int i2 = 0; i2 < arrayAsList.size() - 1; ++i2) {
                if (comparator2.compare(arrayAsList.get(i2), arrayAsList.get(i2 + 1)) <= 0) continue;
                throw failures.failure(info2, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i2, array, comparator2));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(array, comparator2));
        }
    }

    private static <T> List<T> asList(Object array) {
        if (array == null) {
            return null;
        }
        Preconditions.checkArgument(org.assertj.core.util.Arrays.isArray(array), "The object should be an array", new Object[0]);
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(Array.get(array, i2));
        }
        return list;
    }

    private static Comparable<Object>[] arrayOfComparableItems(Object array) {
        ArrayWrapperList arrayWrapperList = ArrayWrapperList.wrap(array);
        Comparable[] arrayOfComparableItems = new Comparable[arrayWrapperList.size()];
        for (int i2 = 0; i2 < arrayWrapperList.size(); ++i2) {
            arrayOfComparableItems[i2] = (Comparable)arrayWrapperList.get(i2);
        }
        return arrayOfComparableItems;
    }

    private static void assertThatArrayComponentTypeIsSortable(AssertionInfo info2, Failures failures, Object array) {
        ArrayWrapperList arrayAsList = ArrayWrapperList.wrap(array);
        Class<?> arrayComponentType = arrayAsList.getComponentType();
        if (arrayComponentType.isPrimitive()) {
            return;
        }
        if (!Comparable.class.isAssignableFrom(arrayComponentType)) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    private static void checkIsNotNullAndNotEmpty(Object values2) {
        Arrays.checkIsNotNull(values2);
        if (Arrays.isArrayEmpty(values2)) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private static void checkIsNotNull(Object values2) {
        if (values2 == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private static boolean isArrayEmpty(Object array) {
        return Arrays.sizeOf(array) == 0;
    }

    private AssertionError arrayDoesNotEndWithSequence(AssertionInfo info2, Failures failures, Object array, Object sequence) {
        return failures.failure(info2, ShouldEndWith.shouldEndWith(array, sequence, this.comparisonStrategy));
    }

    private static void assertNotNull(AssertionInfo info2, Object array) {
        Objects.instance().assertNotNull(info2, array);
    }

    private static int sizeOf(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        return Array.getLength(array);
    }

    private static void failIfEmptySinceActualIsNotEmpty(Object values2) {
        if (Arrays.isArrayEmpty(values2)) {
            throw new AssertionError((Object)"actual is not empty while group of values to look for is.");
        }
    }
}

