/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ElementsShouldSatisfy
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory elementsShouldSatisfyAny(Object actual) {
        return new ElementsShouldSatisfy(actual);
    }

    public static ErrorMessageFactory elementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRestrictions) {
        return new ElementsShouldSatisfy(actual, elementsNotSatisfyingRestrictions);
    }

    private ElementsShouldSatisfy(Object actual) {
        super("%nExpecting any element of:%n  <%s>%nto satisfy the given assertions requirements but none did.", actual);
    }

    private ElementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements) {
        super("%nExpecting all elements of:%n  <%s>%nto satisfy given requirements, but these elements did not:%n%n" + ElementsShouldSatisfy.describeErrors(elementsNotSatisfyingRequirements), actual);
    }

    private static String describeErrors(List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements) {
        return elementsNotSatisfyingRequirements.stream().map(UnsatisfiedRequirement::toString).collect(Collectors.joining("%n%n"));
    }

    public static class UnsatisfiedRequirement {
        private final Object elementNotSatisfyingRequirements;
        private final String errorMessage;

        public UnsatisfiedRequirement(Object elementNotSatisfyingRequirements, String errorMessage2) {
            this.elementNotSatisfyingRequirements = elementNotSatisfyingRequirements;
            this.errorMessage = errorMessage2;
        }

        public String toString() {
            return String.format("  <%s> %s", this.elementNotSatisfyingRequirements, this.errorMessage);
        }
    }
}

