/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;
import org.assertj.core.error.MessageFormatter;

public class SoftAssertionError
extends AssertionError {
    private static final long serialVersionUID = 5034494920024670595L;
    private final List<String> errors;
    private static final MessageFormatter formatter = MessageFormatter.instance();

    public SoftAssertionError(List<String> errors) {
        super((Object)SoftAssertionError.createMessage(errors));
        this.errors = errors;
    }

    private static String createMessage(List<String> errors) {
        StringBuilder msg = new StringBuilder("%nThe following ");
        int size2 = errors.size();
        if (size2 == 1) {
            msg.append("assertion");
        } else {
            msg.append(size2).append(" assertions");
        }
        msg.append(" failed:%n");
        for (int i2 = 0; i2 < size2; ++i2) {
            msg.append(i2 + 1).append(") ").append(errors.get(i2)).append("%n");
        }
        return formatter.format(null, null, msg.toString(), new Object[0]);
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

