/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Streams;
import org.assertj.core.util.VisibleForTesting;

public class IterableAssert<ELEMENT>
extends FactoryBasedNavigableIterableAssert<IterableAssert<ELEMENT>, Iterable<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    public IterableAssert(Iterable<? extends ELEMENT> actual) {
        super(actual, IterableAssert.class, new ObjectAssertFactory());
    }

    public IterableAssert(Iterator<? extends ELEMENT> actual) {
        this(IterableAssert.toLazyIterable(actual));
    }

    @Override
    protected IterableAssert<ELEMENT> newAbstractIterableAssert(Iterable<? extends ELEMENT> iterable) {
        return new IterableAssert<ELEMENT>(iterable);
    }

    @Override
    public IterableAssert<ELEMENT> isEqualTo(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertEqual(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isEqualTo(expected);
    }

    @Override
    public IterableAssert<ELEMENT> isInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isExactlyInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isExactlyInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isNotInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isNotInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isNotOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isNotExactlyInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotExactlyInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isSameAs(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertSame(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isSameAs(expected);
    }

    @Override
    public IterableAssert<ELEMENT> isNotSameAs(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertNotSame(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotSameAs(expected);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> startsWith(ELEMENT ... sequence) {
        if (!(this.actual instanceof LazyIterable)) {
            return (IterableAssert)super.startsWith((Object[])sequence);
        }
        this.objects.assertNotNull(this.info, this.actual);
        CommonValidations.checkIsNotNull(sequence);
        Iterator iterator2 = ((LazyIterable)this.actual).iterator;
        if (sequence.length == 0 && iterator2.hasNext()) {
            throw new AssertionError((Object)"actual is not empty");
        }
        int i2 = 0;
        while (iterator2.hasNext() && i2 < sequence.length) {
            if (this.iterables.getComparisonStrategy().areEqual(iterator2.next(), sequence[i2++])) continue;
            throw this.actualDoesNotStartWithSequence(this.info, (Iterable)this.actual, sequence);
        }
        if (sequence.length > i2) {
            throw this.actualDoesNotStartWithSequence(this.info, (Iterable)this.actual, sequence);
        }
        return (IterableAssert)this.myself;
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info2, Iterable<?> actual, Object[] sequence) {
        return Failures.instance().failure(info2, ShouldStartWith.shouldStartWith(actual, sequence, this.iterables.getComparisonStrategy()));
    }

    private LazyIterable asLazyIterable() {
        return (LazyIterable)this.actual;
    }

    private static <T> Iterable<T> toIterable(Iterator<T> iterator2) {
        return Streams.stream(iterator2).collect(Collectors.toList());
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> contains(ELEMENT ... values2) {
        return (IterableAssert)super.contains((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnly(ELEMENT ... values2) {
        return (IterableAssert)super.containsOnly((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnlyOnce(ELEMENT ... values2) {
        return (IterableAssert)super.containsOnlyOnce((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactly(ELEMENT ... values2) {
        return (IterableAssert)super.containsExactly((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactlyInAnyOrder(ELEMENT ... values2) {
        return (IterableAssert)super.containsExactlyInAnyOrder((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsAnyOf(ELEMENT ... values2) {
        return (IterableAssert)super.containsAnyOf((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> isSubsetOf(ELEMENT ... values2) {
        return (IterableAssert)super.isSubsetOf((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContain(ELEMENT ... values2) {
        return (IterableAssert)super.doesNotContain((Object[])values2);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> endsWith(ELEMENT first2, ELEMENT ... rest) {
        return (IterableAssert)super.endsWith((Object)first2, (Object[])rest);
    }

    @Override
    @SafeVarargs
    public final <EXCEPTION extends Exception> AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... extractors) {
        return super.flatExtracting(extractors);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(Extractor<? super ELEMENT, ?> ... extractors) {
        return super.flatExtracting(extractors);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(Function<ELEMENT, ?> ... extractors) {
        return super.extracting(extractors);
    }

    @VisibleForTesting
    static class LazyIterable<T>
    extends AbstractCollection<T> {
        private Iterator<T> iterator;
        private Iterable<T> iterable;

        public LazyIterable(Iterator<T> iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterable == null) {
                this.iterable = IterableAssert.toIterable(this.iterator);
            }
            return this.iterable.iterator();
        }

        @Override
        public int size() {
            return Math.toIntExact(Streams.stream(this.iterator()).count());
        }
    }
}

