/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ComparatorFactory;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.DoubleArrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleArrayAssert<SELF extends AbstractDoubleArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, double[], Double> {
    @VisibleForTesting
    protected DoubleArrays arrays = DoubleArrays.instance();
    private final ComparatorFactory doubleComparator = ComparatorFactory.INSTANCE;

    public AbstractDoubleArrayAssert(double[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (double[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (double[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (double[])this.actual, expected);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (double[])this.actual, other);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double ... values2) {
        this.arrays.assertContains(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).contains(values2);
    }

    public SELF containsOnly(double ... values2) {
        this.arrays.assertContainsOnly(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsOnly(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsOnly(values2);
    }

    public SELF containsOnlyOnce(double ... values2) {
        this.arrays.assertContainsOnlyOnce(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsOnlyOnce(values2);
    }

    public SELF containsSequence(double ... sequence) {
        this.arrays.assertContainsSequence(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsSequence(double[] sequence, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsSequence(sequence);
    }

    public SELF containsSubsequence(double ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (double[])this.actual, subsequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsSubsequence(double[] subsequence, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsSubsequence(subsequence);
    }

    public SELF contains(double value, Index index) {
        this.arrays.assertContains(this.info, (double[])this.actual, value, index);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double value, Index index, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).contains(value, index);
    }

    public SELF doesNotContain(double ... values2) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotContain(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotContain(values2);
    }

    public SELF doesNotContain(double value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, value, index);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotContain(double value, Index index, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotContain(value, index);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates(Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotHaveDuplicates();
    }

    public SELF startsWith(double ... sequence) {
        this.arrays.assertStartsWith(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF startsWith(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).startsWith(values2);
    }

    public SELF endsWith(double ... sequence) {
        this.arrays.assertEndsWith(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF endsWith(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).endsWith(values2);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Double> comparator2) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (double[])this.actual, comparator2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Double> customComparator) {
        this.arrays = new DoubleArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = DoubleArrays.instance();
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactly(double ... values2) {
        this.arrays.assertContainsExactly(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(double ... values2) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactly(double[] values2, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsExactly(values2);
    }

    @CheckReturnValue
    public SELF usingComparatorWithPrecision(Double precision) {
        return (SELF)this.usingElementComparator(this.doubleComparator.doubleComparatorWithPrecision(precision));
    }

    public SELF containsAnyOf(double ... values2) {
        this.arrays.assertContainsAnyOf(this.info, (double[])this.actual, values2);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }
}

