/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.visitor;

import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class ExceptionTableSensitiveMethodVisitor
extends MethodVisitor {
    private boolean trigger = true;

    protected ExceptionTableSensitiveMethodVisitor(int api, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
    }

    private void considerEndOfExceptionTable() {
        if (this.trigger) {
            this.trigger = false;
            this.onAfterExceptionTable();
        }
    }

    protected abstract void onAfterExceptionTable();

    public final void visitFrame(int type2, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack2) {
        this.considerEndOfExceptionTable();
        this.onVisitFrame(type2, localVariableLength, localVariable, stackSize, stack2);
    }

    protected void onVisitFrame(int type2, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack2) {
        super.visitFrame(type2, localVariableLength, localVariable, stackSize, stack2);
    }

    public final void visitLabel(Label label) {
        this.considerEndOfExceptionTable();
        this.onVisitLabel(label);
    }

    protected void onVisitLabel(Label label) {
        super.visitLabel(label);
    }

    public final void visitIntInsn(int opcode, int operand) {
        this.considerEndOfExceptionTable();
        this.onVisitIntInsn(opcode, operand);
    }

    protected void onVisitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
    }

    public final void visitVarInsn(int opcode, int offset) {
        this.considerEndOfExceptionTable();
        this.onVisitVarInsn(opcode, offset);
    }

    protected void onVisitVarInsn(int opcode, int offset) {
        super.visitVarInsn(opcode, offset);
    }

    public final void visitTypeInsn(int opcode, String type2) {
        this.considerEndOfExceptionTable();
        this.onVisitTypeInsn(opcode, type2);
    }

    protected void onVisitTypeInsn(int opcode, String type2) {
        super.visitTypeInsn(opcode, type2);
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        this.considerEndOfExceptionTable();
        this.onVisitFieldInsn(opcode, owner, name, descriptor2);
    }

    protected void onVisitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        super.visitFieldInsn(opcode, owner, name, descriptor2);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String descriptor2) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, descriptor2);
    }

    @Deprecated
    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor2) {
        super.visitMethodInsn(opcode, owner, name, descriptor2);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        this.considerEndOfExceptionTable();
        this.onVisitMethodInsn(opcode, owner, name, descriptor2, isInterface);
    }

    protected void onVisitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor2, isInterface);
    }

    public final void visitInvokeDynamicInsn(String name, String descriptor2, Handle handle2, Object ... argument) {
        this.considerEndOfExceptionTable();
        this.onVisitInvokeDynamicInsn(name, descriptor2, handle2, argument);
    }

    protected void onVisitInvokeDynamicInsn(String name, String descriptor2, Handle handle2, Object ... argument) {
        super.visitInvokeDynamicInsn(name, descriptor2, handle2, argument);
    }

    public final void visitJumpInsn(int opcode, Label label) {
        this.considerEndOfExceptionTable();
        this.onVisitJumpInsn(opcode, label);
    }

    protected void onVisitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
    }

    public final void visitLdcInsn(Object constant) {
        this.considerEndOfExceptionTable();
        this.onVisitLdcInsn(constant);
    }

    protected void onVisitLdcInsn(Object constant) {
        super.visitLdcInsn(constant);
    }

    public final void visitIincInsn(int offset, int increment) {
        this.considerEndOfExceptionTable();
        this.onVisitIincInsn(offset, increment);
    }

    protected void onVisitIincInsn(int offset, int increment) {
        super.visitIincInsn(offset, increment);
    }

    public final void visitTableSwitchInsn(int minimum, int maximum, Label defaultTarget, Label ... label) {
        this.considerEndOfExceptionTable();
        this.onVisitTableSwitchInsn(minimum, maximum, defaultTarget, label);
    }

    protected void onVisitTableSwitchInsn(int minimum, int maximum, Label defaultTarget, Label ... label) {
        super.visitTableSwitchInsn(minimum, maximum, defaultTarget, label);
    }

    public final void visitLookupSwitchInsn(Label dflt, int[] key2, Label[] label) {
        this.considerEndOfExceptionTable();
        this.onVisitLookupSwitchInsn(dflt, key2, label);
    }

    protected void onVisitLookupSwitchInsn(Label defaultTarget, int[] key2, Label[] label) {
        super.visitLookupSwitchInsn(defaultTarget, key2, label);
    }

    public final void visitMultiANewArrayInsn(String descriptor2, int dimensions) {
        this.considerEndOfExceptionTable();
        this.onVisitMultiANewArrayInsn(descriptor2, dimensions);
    }

    protected void onVisitMultiANewArrayInsn(String descriptor2, int dimensions) {
        super.visitMultiANewArrayInsn(descriptor2, dimensions);
    }

    public final void visitInsn(int opcode) {
        this.considerEndOfExceptionTable();
        this.onVisitInsn(opcode);
    }

    protected void onVisitInsn(int opcode) {
        super.visitInsn(opcode);
    }
}

