/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class TypeReferenceAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final boolean strict;
    private final ElementMatcher.Junction<? super TypeDescription> filter;

    protected TypeReferenceAdjustment(boolean strict, ElementMatcher.Junction<? super TypeDescription> filter2) {
        this.strict = strict;
        this.filter = filter2;
    }

    public static TypeReferenceAdjustment strict() {
        return new TypeReferenceAdjustment(true, ElementMatchers.none());
    }

    public static TypeReferenceAdjustment relaxed() {
        return new TypeReferenceAdjustment(false, ElementMatchers.none());
    }

    public TypeReferenceAdjustment filter(ElementMatcher<? super TypeDescription> filter2) {
        return new TypeReferenceAdjustment(this.strict, this.filter.or(filter2));
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields2, MethodList<?> methods2, int writerFlags, int readerFlags) {
        return new TypeReferenceClassVisitor(classVisitor, this.strict, this.filter, typePool);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.strict != ((TypeReferenceAdjustment)object).strict) {
            return false;
        }
        return this.filter.equals(((TypeReferenceAdjustment)object).filter);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.strict) * 31 + this.filter.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeReferenceClassVisitor
    extends ClassVisitor {
        @AlwaysNull
        private static final AnnotationVisitor IGNORE_ANNOTATION = null;
        @AlwaysNull
        private static final FieldVisitor IGNORE_FIELD = null;
        @AlwaysNull
        private static final MethodVisitor IGNORE_METHOD = null;
        private final boolean strict;
        private final ElementMatcher<? super TypeDescription> filter;
        private final TypePool typePool;
        private final Set<String> observedTypes;
        private final Set<String> visitedInnerTypes;

        protected TypeReferenceClassVisitor(ClassVisitor classVisitor, boolean strict, ElementMatcher<? super TypeDescription> filter2, TypePool typePool) {
            super(OpenedClassReader.ASM_API, classVisitor);
            this.typePool = typePool;
            this.strict = strict;
            this.filter = filter2;
            this.observedTypes = new HashSet<String>();
            this.visitedInnerTypes = new HashSet<String>();
        }

        @Override
        public void visit(int version2, int modifiers, String internalName, @MaybeNull String genericSignature, @MaybeNull String superClassInternalName, @MaybeNull String[] interfaceInternalName) {
            if (superClassInternalName != null) {
                this.observedTypes.add(superClassInternalName);
            }
            if (interfaceInternalName != null) {
                this.observedTypes.addAll(Arrays.asList(interfaceInternalName));
            }
            super.visit(version2, modifiers, internalName, genericSignature, superClassInternalName, interfaceInternalName);
        }

        @Override
        public void visitNestHost(String nestHost) {
            this.observedTypes.add(nestHost);
            super.visitNestHost(nestHost);
        }

        @Override
        public void visitOuterClass(String ownerTypeInternalName, String methodName, String methodDescriptor) {
            this.observedTypes.add(ownerTypeInternalName);
            super.visitOuterClass(ownerTypeInternalName, methodName, methodDescriptor);
        }

        @Override
        public void visitNestMember(String nestMember) {
            this.observedTypes.add(nestMember);
            super.visitNestMember(nestMember);
        }

        @Override
        public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
            this.visitedInnerTypes.add(internalName);
            super.visitInnerClass(internalName, outerName, innerName, modifiers);
        }

        @Override
        @MaybeNull
        public RecordComponentVisitor visitRecordComponent(String name, String descriptor2, @MaybeNull String signature2) {
            this.observedTypes.add(Type.getType(descriptor2).getInternalName());
            return super.visitRecordComponent(name, descriptor2, signature2);
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
            this.observedTypes.add(Type.getType(descriptor2).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor2, visible);
            if (annotationVisitor != null) {
                return new TypeReferenceAnnotationVisitor(annotationVisitor);
            }
            return IGNORE_ANNOTATION;
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitTypeAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor2, boolean visible) {
            this.observedTypes.add(Type.getType(descriptor2).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, typePath, descriptor2, visible);
            if (annotationVisitor != null) {
                return new TypeReferenceAnnotationVisitor(annotationVisitor);
            }
            return IGNORE_ANNOTATION;
        }

        @Override
        @MaybeNull
        public FieldVisitor visitField(int modifiers, String name, String descriptor2, @MaybeNull String signature2, @MaybeNull Object value) {
            FieldVisitor fieldVisitor = super.visitField(modifiers, name, descriptor2, signature2, value);
            if (fieldVisitor != null) {
                this.resolve(Type.getType(descriptor2));
                return new TypeReferenceFieldVisitor(fieldVisitor);
            }
            return IGNORE_FIELD;
        }

        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor2, @MaybeNull String signature2, @MaybeNull String[] exceptionInternalName) {
            MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor2, signature2, exceptionInternalName);
            if (methodVisitor != null) {
                this.resolve(Type.getType(descriptor2));
                if (exceptionInternalName != null) {
                    this.observedTypes.addAll(Arrays.asList(exceptionInternalName));
                }
                return new TypeReferenceMethodVisitor(methodVisitor);
            }
            return IGNORE_METHOD;
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
        public void visitEnd() {
            block2: for (String observedType : this.observedTypes) {
                if (!this.visitedInnerTypes.add(observedType)) continue;
                TypePool.Resolution resolution = this.typePool.describe(observedType.replace('/', '.'));
                if (resolution.isResolved()) {
                    TypeDescription typeDescription = resolution.resolve();
                    if (this.filter.matches(typeDescription)) continue;
                    while (typeDescription != null && typeDescription.isNestedClass()) {
                        super.visitInnerClass(typeDescription.getInternalName(), typeDescription.isMemberType() ? typeDescription.getDeclaringType().getInternalName() : null, typeDescription.isAnonymousType() ? null : typeDescription.getSimpleName(), typeDescription.getModifiers());
                        try {
                            while ((typeDescription = typeDescription.getEnclosingType()) != null && !this.visitedInnerTypes.add(typeDescription.getInternalName())) {
                            }
                        }
                        catch (RuntimeException exception) {
                            if (!this.strict) continue block2;
                            throw exception;
                        }
                    }
                    continue;
                }
                if (!this.strict) continue;
                throw new IllegalStateException("Could not locate type for: " + observedType.replace('/', '.'));
            }
            super.visitEnd();
        }

        protected void resolve(Type type2) {
            if (type2.getSort() == 11) {
                this.resolve(type2.getReturnType());
                for (Type argumentType : type2.getArgumentTypes()) {
                    this.resolve(argumentType);
                }
            } else {
                while (type2.getSort() == 9) {
                    type2 = type2.getElementType();
                }
                if (type2.getSort() == 10) {
                    this.observedTypes.add(type2.getInternalName());
                }
            }
        }

        protected void resolve(Handle handle2) {
            this.observedTypes.add(handle2.getOwner());
            Type methodType = Type.getType(handle2.getDesc());
            this.resolve(methodType.getReturnType());
            for (Type type2 : methodType.getArgumentTypes()) {
                this.resolve(type2);
            }
        }

        protected void resolve(ConstantDynamic constant) {
            Type methodType = Type.getType(constant.getDescriptor());
            this.resolve(methodType.getReturnType());
            for (Type type2 : methodType.getArgumentTypes()) {
                this.resolve(type2);
            }
            this.resolve(constant.getBootstrapMethod());
            for (int index = 0; index < constant.getBootstrapMethodArgumentCount(); ++index) {
                this.resolve(constant.getBootstrapMethodArgument(index));
            }
        }

        private void observeInternalName(String internalName) {
            int index = internalName.lastIndexOf(91);
            if (index != -1) {
                internalName = internalName.substring(index + 2, internalName.length() - 1);
            }
            this.observedTypes.add(internalName);
        }

        protected void resolve(Object value) {
            if (value instanceof Type) {
                this.resolve((Type)value);
            } else if (value instanceof Handle) {
                this.resolve((Handle)value);
            } else if (value instanceof ConstantDynamic) {
                this.resolve((ConstantDynamic)value);
            }
        }

        protected class TypeReferenceMethodVisitor
        extends MethodVisitor {
            protected TypeReferenceMethodVisitor(MethodVisitor methodVisitor) {
                super(OpenedClassReader.ASM_API, methodVisitor);
            }

            @MaybeNull
            public AnnotationVisitor visitAnnotationDefault() {
                AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitTypeAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, typePath, descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitParameterAnnotation(int index, String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(index, descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitInsnAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeReference, typePath, descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitTryCatchAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeReference, typePath, descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, @MaybeNull TypePath typePath, Label[] start2, Label[] end2, int[] index, String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeReference, typePath, start2, end2, index, descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            public void visitTypeInsn(int opcode, String internalName) {
                TypeReferenceClassVisitor.this.observeInternalName(internalName);
                super.visitTypeInsn(opcode, internalName);
            }

            public void visitFieldInsn(int opcode, String ownerInternalName, String name, String descriptor2) {
                TypeReferenceClassVisitor.this.observeInternalName(ownerInternalName);
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor2));
                super.visitFieldInsn(opcode, ownerInternalName, name, descriptor2);
            }

            public void visitMethodInsn(int opcode, String ownerInternalName, String name, String descriptor2, boolean isInterface) {
                TypeReferenceClassVisitor.this.observeInternalName(ownerInternalName);
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor2));
                super.visitMethodInsn(opcode, ownerInternalName, name, descriptor2, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor2, Handle handle2, Object ... argument) {
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor2));
                TypeReferenceClassVisitor.this.resolve(handle2);
                for (Object anArgument : argument) {
                    TypeReferenceClassVisitor.this.resolve(anArgument);
                }
                super.visitInvokeDynamicInsn(name, descriptor2, handle2, argument);
            }

            public void visitLdcInsn(Object value) {
                TypeReferenceClassVisitor.this.resolve(value);
                super.visitLdcInsn(value);
            }

            public void visitMultiANewArrayInsn(String descriptor2, int dimension) {
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor2));
                super.visitMultiANewArrayInsn(descriptor2, dimension);
            }

            public void visitTryCatchBlock(Label start2, Label end2, Label handler2, @MaybeNull String typeInternalName) {
                if (typeInternalName != null) {
                    TypeReferenceClassVisitor.this.observedTypes.add(typeInternalName);
                }
                super.visitTryCatchBlock(start2, end2, handler2, typeInternalName);
            }
        }

        protected class TypeReferenceFieldVisitor
        extends FieldVisitor {
            protected TypeReferenceFieldVisitor(FieldVisitor fieldVisitor) {
                super(OpenedClassReader.ASM_API, fieldVisitor);
            }

            @MaybeNull
            public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor2, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }
        }

        protected class TypeReferenceAnnotationVisitor
        extends AnnotationVisitor {
            protected TypeReferenceAnnotationVisitor(AnnotationVisitor annotationVisitor) {
                super(OpenedClassReader.ASM_API, annotationVisitor);
            }

            public void visit(String name, Object value) {
                TypeReferenceClassVisitor.this.resolve(value);
                super.visit(name, value);
            }

            public void visitEnum(String name, String descriptor2, String value) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                super.visitEnum(name, descriptor2, value);
            }

            @MaybeNull
            public AnnotationVisitor visitAnnotation(String name, String descriptor2) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor2).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(name, descriptor2);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @MaybeNull
            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor annotationVisitor = super.visitArray(name);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }
        }
    }
}

