/*
 * Decompiled with CFR 0.152.
 */
package model.board;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import model.board.Board;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J-\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lmodel/board/Game;", "", "players", "", "Lmodel/player/Player;", "board", "Lmodel/board/Board;", "roundCounter", "", "(Ljava/util/List;Lmodel/board/Board;I)V", "getBoard", "()Lmodel/board/Board;", "current", "getCurrent", "()Lmodel/player/Player;", "nextPlayer", "getNextPlayer", "getPlayers", "()Ljava/util/List;", "getRoundCounter", "()I", "setRoundCounter", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "startNextRound", "", "toString", "", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Game.kt\nmodel/board/Game\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class Game {
    @NotNull
    private final List<Player> players;
    @NotNull
    private final Board board;
    private int roundCounter;

    public Game(@NotNull List<? extends Player> players2, @NotNull Board board, int roundCounter) {
        Intrinsics.checkNotNullParameter(players2, "players");
        Intrinsics.checkNotNullParameter(board, "board");
        this.players = players2;
        this.board = board;
        this.roundCounter = roundCounter;
    }

    public /* synthetic */ Game(List list, Board board, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(list, board, n);
    }

    @NotNull
    public final List<Player> getPlayers() {
        return this.players;
    }

    @NotNull
    public final Board getBoard() {
        return this.board;
    }

    public final int getRoundCounter() {
        return this.roundCounter;
    }

    public final void setRoundCounter(int n) {
        this.roundCounter = n;
    }

    @Nullable
    public final Player getCurrent() {
        Object v0;
        block1: {
            Iterable iterable = this.players;
            for (Object t : iterable) {
                Player it = (Player)t;
                boolean bl = false;
                if (!it.isCurrentPlayer()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Player getNextPlayer() {
        int playingPlayerIndex = CollectionsKt.indexOf(this.players, this.getCurrent());
        return this.players.get((playingPlayerIndex + 1) % this.players.size());
    }

    public final void startNextRound() {
        Player player = this.getCurrent();
        Intrinsics.checkNotNull(player);
        Player oldCurrent = player;
        this.getNextPlayer().setCurrentPlayer(true);
        oldCurrent.setCurrentPlayer(false);
        ++this.roundCounter;
    }

    @NotNull
    public final List<Player> component1() {
        return this.players;
    }

    @NotNull
    public final Board component2() {
        return this.board;
    }

    public final int component3() {
        return this.roundCounter;
    }

    @NotNull
    public final Game copy(@NotNull List<? extends Player> players2, @NotNull Board board, int roundCounter) {
        Intrinsics.checkNotNullParameter(players2, "players");
        Intrinsics.checkNotNullParameter(board, "board");
        return new Game(players2, board, roundCounter);
    }

    public static /* synthetic */ Game copy$default(Game game, List list, Board board, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = game.players;
        }
        if ((n2 & 2) != 0) {
            board = game.board;
        }
        if ((n2 & 4) != 0) {
            n = game.roundCounter;
        }
        return game.copy(list, board, n);
    }

    @NotNull
    public String toString() {
        return "Game(players=" + this.players + ", board=" + this.board + ", roundCounter=" + this.roundCounter + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.players).hashCode();
        result2 = result2 * 31 + this.board.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.roundCounter);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Game)) {
            return false;
        }
        Game game = (Game)other;
        if (!Intrinsics.areEqual(this.players, game.players)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.board, game.board)) {
            return false;
        }
        return this.roundCounter == game.roundCounter;
    }
}

